package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  LocaleId,
  DraftBotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class UpdateBotRecommendationResponse(
    botId: Option[Id] = None,
    botVersion: Option[DraftBotVersion] = None,
    localeId: Option[LocaleId] = None,
    botRecommendationStatus: Option[
      zio.aws.lexmodelsv2.model.BotRecommendationStatus
    ] = None,
    botRecommendationId: Option[Id] = None,
    creationDateTime: Option[Timestamp] = None,
    lastUpdatedDateTime: Option[Timestamp] = None,
    transcriptSourceSetting: Option[
      zio.aws.lexmodelsv2.model.TranscriptSourceSetting
    ] = None,
    encryptionSetting: Option[zio.aws.lexmodelsv2.model.EncryptionSetting] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse = {
    import UpdateBotRecommendationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => DraftBotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(botRecommendationStatus.map(value => value.unwrap))(
        _.botRecommendationStatus
      )
      .optionallyWith(
        botRecommendationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.botRecommendationId)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        transcriptSourceSetting.map(value => value.buildAwsValue())
      )(_.transcriptSourceSetting)
      .optionallyWith(encryptionSetting.map(value => value.buildAwsValue()))(
        _.encryptionSetting
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse
      .wrap(buildAwsValue())
}
object UpdateBotRecommendationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse =
      zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        botRecommendationStatus.map(value => value),
        botRecommendationId.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        transcriptSourceSetting.map(value => value.asEditable),
        encryptionSetting.map(value => value.asEditable)
      )
    def botId: Option[Id]
    def botVersion: Option[DraftBotVersion]
    def localeId: Option[LocaleId]
    def botRecommendationStatus
        : Option[zio.aws.lexmodelsv2.model.BotRecommendationStatus]
    def botRecommendationId: Option[Id]
    def creationDateTime: Option[Timestamp]
    def lastUpdatedDateTime: Option[Timestamp]
    def transcriptSourceSetting
        : Option[zio.aws.lexmodelsv2.model.TranscriptSourceSetting.ReadOnly]
    def encryptionSetting
        : Option[zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, DraftBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getBotRecommendationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotRecommendationStatus
    ] = AwsError.unwrapOptionField(
      "botRecommendationStatus",
      botRecommendationStatus
    )
    def getBotRecommendationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botRecommendationId", botRecommendationId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getTranscriptSourceSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.TranscriptSourceSetting.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transcriptSourceSetting",
      transcriptSourceSetting
    )
    def getEncryptionSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly
    ] = AwsError.unwrapOptionField("encryptionSetting", encryptionSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse
  ) extends zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[DraftBotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val botRecommendationStatus
        : Option[zio.aws.lexmodelsv2.model.BotRecommendationStatus] = scala
      .Option(impl.botRecommendationStatus())
      .map(value =>
        zio.aws.lexmodelsv2.model.BotRecommendationStatus.wrap(value)
      )
    override val botRecommendationId: Option[Id] = scala
      .Option(impl.botRecommendationId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val transcriptSourceSetting
        : Option[zio.aws.lexmodelsv2.model.TranscriptSourceSetting.ReadOnly] =
      scala
        .Option(impl.transcriptSourceSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.TranscriptSourceSetting.wrap(value)
        )
    override val encryptionSetting
        : Option[zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly] = scala
      .Option(impl.encryptionSetting())
      .map(value => zio.aws.lexmodelsv2.model.EncryptionSetting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.UpdateBotRecommendationResponse
  ): zio.aws.lexmodelsv2.model.UpdateBotRecommendationResponse.ReadOnly =
    new Wrapper(impl)
}
