package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SlotValueSelectionSetting(
    resolutionStrategy: zio.aws.lexmodelsv2.model.SlotValueResolutionStrategy,
    regexFilter: Option[zio.aws.lexmodelsv2.model.SlotValueRegexFilter] = None,
    advancedRecognitionSetting: Option[
      zio.aws.lexmodelsv2.model.AdvancedRecognitionSetting
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotValueSelectionSetting = {
    import SlotValueSelectionSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotValueSelectionSetting
      .builder()
      .resolutionStrategy(resolutionStrategy.unwrap)
      .optionallyWith(regexFilter.map(value => value.buildAwsValue()))(
        _.regexFilter
      )
      .optionallyWith(
        advancedRecognitionSetting.map(value => value.buildAwsValue())
      )(_.advancedRecognitionSetting)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.wrap(buildAwsValue())
}
object SlotValueSelectionSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotValueSelectionSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotValueSelectionSetting =
      zio.aws.lexmodelsv2.model.SlotValueSelectionSetting(
        resolutionStrategy,
        regexFilter.map(value => value.asEditable),
        advancedRecognitionSetting.map(value => value.asEditable)
      )
    def resolutionStrategy
        : zio.aws.lexmodelsv2.model.SlotValueResolutionStrategy
    def regexFilter
        : Option[zio.aws.lexmodelsv2.model.SlotValueRegexFilter.ReadOnly]
    def advancedRecognitionSetting
        : Option[zio.aws.lexmodelsv2.model.AdvancedRecognitionSetting.ReadOnly]
    def getResolutionStrategy: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.SlotValueResolutionStrategy
    ] = ZIO.succeed(resolutionStrategy)
    def getRegexFilter: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SlotValueRegexFilter.ReadOnly
    ] = AwsError.unwrapOptionField("regexFilter", regexFilter)
    def getAdvancedRecognitionSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.AdvancedRecognitionSetting.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedRecognitionSetting",
      advancedRecognitionSetting
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotValueSelectionSetting
  ) extends zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.ReadOnly {
    override val resolutionStrategy
        : zio.aws.lexmodelsv2.model.SlotValueResolutionStrategy =
      zio.aws.lexmodelsv2.model.SlotValueResolutionStrategy
        .wrap(impl.resolutionStrategy())
    override val regexFilter
        : Option[zio.aws.lexmodelsv2.model.SlotValueRegexFilter.ReadOnly] =
      scala
        .Option(impl.regexFilter())
        .map(value =>
          zio.aws.lexmodelsv2.model.SlotValueRegexFilter.wrap(value)
        )
    override val advancedRecognitionSetting: Option[
      zio.aws.lexmodelsv2.model.AdvancedRecognitionSetting.ReadOnly
    ] = scala
      .Option(impl.advancedRecognitionSetting())
      .map(value =>
        zio.aws.lexmodelsv2.model.AdvancedRecognitionSetting.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotValueSelectionSetting
  ): zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.ReadOnly = new Wrapper(
    impl
  )
}
