package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Description, SlotTypeSignature}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BuiltInSlotTypeSummary(
    slotTypeSignature: Option[SlotTypeSignature] = None,
    description: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BuiltInSlotTypeSummary = {
    import BuiltInSlotTypeSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BuiltInSlotTypeSummary
      .builder()
      .optionallyWith(
        slotTypeSignature.map(value =>
          SlotTypeSignature.unwrap(value): java.lang.String
        )
      )(_.slotTypeSignature)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BuiltInSlotTypeSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.BuiltInSlotTypeSummary.wrap(buildAwsValue())
}
object BuiltInSlotTypeSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BuiltInSlotTypeSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BuiltInSlotTypeSummary =
      zio.aws.lexmodelsv2.model.BuiltInSlotTypeSummary(
        slotTypeSignature.map(value => value),
        description.map(value => value)
      )
    def slotTypeSignature: Option[SlotTypeSignature]
    def description: Option[Description]
    def getSlotTypeSignature: ZIO[Any, AwsError, SlotTypeSignature] =
      AwsError.unwrapOptionField("slotTypeSignature", slotTypeSignature)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BuiltInSlotTypeSummary
  ) extends zio.aws.lexmodelsv2.model.BuiltInSlotTypeSummary.ReadOnly {
    override val slotTypeSignature: Option[SlotTypeSignature] = scala
      .Option(impl.slotTypeSignature())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.SlotTypeSignature(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BuiltInSlotTypeSummary
  ): zio.aws.lexmodelsv2.model.BuiltInSlotTypeSummary.ReadOnly = new Wrapper(
    impl
  )
}
