package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  NextToken,
  MaxResults,
  BotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSlotsRequest(
    botId: Id,
    botVersion: BotVersion,
    localeId: LocaleId,
    intentId: Id,
    sortBy: Option[zio.aws.lexmodelsv2.model.SlotSortBy] = None,
    filters: Option[Iterable[zio.aws.lexmodelsv2.model.SlotFilter]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest = {
    import ListSlotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(BotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .intentId(Id.unwrap(intentId): java.lang.String)
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListSlotsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListSlotsRequest.wrap(buildAwsValue())
}
object ListSlotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListSlotsRequest =
      zio.aws.lexmodelsv2.model.ListSlotsRequest(
        botId,
        botVersion,
        localeId,
        intentId,
        sortBy.map(value => value.asEditable),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def botId: Id
    def botVersion: BotVersion
    def localeId: LocaleId
    def intentId: Id
    def sortBy: Option[zio.aws.lexmodelsv2.model.SlotSortBy.ReadOnly]
    def filters: Option[List[zio.aws.lexmodelsv2.model.SlotFilter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, BotVersion] = ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getIntentId: ZIO[Any, Nothing, Id] = ZIO.succeed(intentId)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.SlotSortBy.ReadOnly] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SlotFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest
  ) extends zio.aws.lexmodelsv2.model.ListSlotsRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: BotVersion =
      zio.aws.lexmodelsv2.model.primitives.BotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val intentId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.intentId())
    override val sortBy: Option[zio.aws.lexmodelsv2.model.SlotSortBy.ReadOnly] =
      scala
        .Option(impl.sortBy())
        .map(value => zio.aws.lexmodelsv2.model.SlotSortBy.wrap(value))
    override val filters
        : Option[List[zio.aws.lexmodelsv2.model.SlotFilter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.SlotFilter.wrap(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest
  ): zio.aws.lexmodelsv2.model.ListSlotsRequest.ReadOnly = new Wrapper(impl)
}
