package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.Id
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteImportResponse(
    importId: Option[Id] = None,
    importStatus: Option[zio.aws.lexmodelsv2.model.ImportStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportResponse = {
    import DeleteImportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportResponse
      .builder()
      .optionallyWith(
        importId.map(value => Id.unwrap(value): java.lang.String)
      )(_.importId)
      .optionallyWith(importStatus.map(value => value.unwrap))(_.importStatus)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteImportResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteImportResponse.wrap(buildAwsValue())
}
object DeleteImportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteImportResponse =
      zio.aws.lexmodelsv2.model.DeleteImportResponse(
        importId.map(value => value),
        importStatus.map(value => value)
      )
    def importId: Option[Id]
    def importStatus: Option[zio.aws.lexmodelsv2.model.ImportStatus]
    def getImportId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("importId", importId)
    def getImportStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ImportStatus] =
      AwsError.unwrapOptionField("importStatus", importStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportResponse
  ) extends zio.aws.lexmodelsv2.model.DeleteImportResponse.ReadOnly {
    override val importId: Option[Id] = scala
      .Option(impl.importId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val importStatus: Option[zio.aws.lexmodelsv2.model.ImportStatus] =
      scala
        .Option(impl.importStatus())
        .map(value => zio.aws.lexmodelsv2.model.ImportStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteImportResponse
  ): zio.aws.lexmodelsv2.model.DeleteImportResponse.ReadOnly = new Wrapper(impl)
}
