package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Id, BotAliasId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteBotAliasResponse(
    botAliasId: Option[BotAliasId] = None,
    botId: Option[Id] = None,
    botAliasStatus: Option[zio.aws.lexmodelsv2.model.BotAliasStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse = {
    import DeleteBotAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse
      .builder()
      .optionallyWith(
        botAliasId.map(value => BotAliasId.unwrap(value): java.lang.String)
      )(_.botAliasId)
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(botAliasStatus.map(value => value.unwrap))(
        _.botAliasStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.wrap(buildAwsValue())
}
object DeleteBotAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteBotAliasResponse =
      zio.aws.lexmodelsv2.model.DeleteBotAliasResponse(
        botAliasId.map(value => value),
        botId.map(value => value),
        botAliasStatus.map(value => value)
      )
    def botAliasId: Option[BotAliasId]
    def botId: Option[Id]
    def botAliasStatus: Option[zio.aws.lexmodelsv2.model.BotAliasStatus]
    def getBotAliasId: ZIO[Any, AwsError, BotAliasId] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotAliasStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotAliasStatus] =
      AwsError.unwrapOptionField("botAliasStatus", botAliasStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse
  ) extends zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.ReadOnly {
    override val botAliasId: Option[BotAliasId] = scala
      .Option(impl.botAliasId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotAliasId(value))
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botAliasStatus
        : Option[zio.aws.lexmodelsv2.model.BotAliasStatus] = scala
      .Option(impl.botAliasStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotAliasStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotAliasResponse
  ): zio.aws.lexmodelsv2.model.DeleteBotAliasResponse.ReadOnly = new Wrapper(
    impl
  )
}
