package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AudioLogSetting(
    enabled: Boolean,
    destination: zio.aws.lexmodelsv2.model.AudioLogDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.AudioLogSetting = {
    import AudioLogSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.AudioLogSetting
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .destination(destination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.AudioLogSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.AudioLogSetting.wrap(buildAwsValue())
}
object AudioLogSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.AudioLogSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.AudioLogSetting =
      zio.aws.lexmodelsv2.model.AudioLogSetting(enabled, destination.asEditable)
    def enabled: Boolean
    def destination: zio.aws.lexmodelsv2.model.AudioLogDestination.ReadOnly
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.lexmodelsv2.model.AudioLogDestination.ReadOnly
    ] = ZIO.succeed(destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AudioLogSetting
  ) extends zio.aws.lexmodelsv2.model.AudioLogSetting.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val destination
        : zio.aws.lexmodelsv2.model.AudioLogDestination.ReadOnly =
      zio.aws.lexmodelsv2.model.AudioLogDestination.wrap(impl.destination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.AudioLogSetting
  ): zio.aws.lexmodelsv2.model.AudioLogSetting.ReadOnly = new Wrapper(impl)
}
