package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.FilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportFilter(
    name: zio.aws.lexmodelsv2.model.ImportFilterName,
    values: Iterable[FilterValue],
    operator: zio.aws.lexmodelsv2.model.ImportFilterOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ImportFilter = {
    import ImportFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ImportFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ImportFilter.ReadOnly =
    zio.aws.lexmodelsv2.model.ImportFilter.wrap(buildAwsValue())
}
object ImportFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ImportFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ImportFilter =
      zio.aws.lexmodelsv2.model.ImportFilter(name, values, operator)
    def name: zio.aws.lexmodelsv2.model.ImportFilterName
    def values: List[FilterValue]
    def operator: zio.aws.lexmodelsv2.model.ImportFilterOperator
    def getName: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.ImportFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.ImportFilterOperator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ImportFilter
  ) extends zio.aws.lexmodelsv2.model.ImportFilter.ReadOnly {
    override val name: zio.aws.lexmodelsv2.model.ImportFilterName =
      zio.aws.lexmodelsv2.model.ImportFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.primitives.FilterValue(item)
      }
      .toList
    override val operator: zio.aws.lexmodelsv2.model.ImportFilterOperator =
      zio.aws.lexmodelsv2.model.ImportFilterOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ImportFilter
  ): zio.aws.lexmodelsv2.model.ImportFilter.ReadOnly = new Wrapper(impl)
}
