package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  ConditionKey,
  RevisionId,
  Operation,
  ConditionOperator,
  AmazonResourceName,
  ConditionValue,
  Name
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateResourcePolicyStatementRequest(
    resourceArn: AmazonResourceName,
    statementId: Name,
    effect: zio.aws.lexmodelsv2.model.Effect,
    principal: Iterable[zio.aws.lexmodelsv2.model.Principal],
    action: Iterable[Operation],
    condition: Option[
      Map[ConditionOperator, Map[ConditionKey, ConditionValue]]
    ] = None,
    expectedRevisionId: Option[RevisionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest = {
    import CreateResourcePolicyStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .statementId(Name.unwrap(statementId): java.lang.String)
      .effect(effect.unwrap)
      .principal(principal.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .action(action.map { item =>
        Operation.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        condition.map(value =>
          value
            .map({ case (key, value) =>
              (ConditionOperator.unwrap(key): java.lang.String) -> value
                .map({ case (key, value) =>
                  (ConditionKey
                    .unwrap(key): java.lang.String) -> (ConditionValue
                    .unwrap(value): java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.condition)
      .optionallyWith(
        expectedRevisionId.map(value =>
          RevisionId.unwrap(value): java.lang.String
        )
      )(_.expectedRevisionId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementRequest
      .wrap(buildAwsValue())
}
object CreateResourcePolicyStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementRequest =
      zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementRequest(
        resourceArn,
        statementId,
        effect,
        principal.map { item =>
          item.asEditable
        },
        action,
        condition.map(value => value),
        expectedRevisionId.map(value => value)
      )
    def resourceArn: AmazonResourceName
    def statementId: Name
    def effect: zio.aws.lexmodelsv2.model.Effect
    def principal: List[zio.aws.lexmodelsv2.model.Principal.ReadOnly]
    def action: List[Operation]
    def condition
        : Option[Map[ConditionOperator, Map[ConditionKey, ConditionValue]]]
    def expectedRevisionId: Option[RevisionId]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getStatementId: ZIO[Any, Nothing, Name] = ZIO.succeed(statementId)
    def getEffect: ZIO[Any, Nothing, zio.aws.lexmodelsv2.model.Effect] =
      ZIO.succeed(effect)
    def getPrincipal: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.Principal.ReadOnly
    ]] = ZIO.succeed(principal)
    def getAction: ZIO[Any, Nothing, List[Operation]] = ZIO.succeed(action)
    def getCondition: ZIO[Any, AwsError, Map[
      ConditionOperator,
      Map[ConditionKey, ConditionValue]
    ]] = AwsError.unwrapOptionField("condition", condition)
    def getExpectedRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("expectedRevisionId", expectedRevisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest
  ) extends zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.lexmodelsv2.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val statementId: Name =
      zio.aws.lexmodelsv2.model.primitives.Name(impl.statementId())
    override val effect: zio.aws.lexmodelsv2.model.Effect =
      zio.aws.lexmodelsv2.model.Effect.wrap(impl.effect())
    override val principal: List[zio.aws.lexmodelsv2.model.Principal.ReadOnly] =
      impl
        .principal()
        .asScala
        .map { item =>
          zio.aws.lexmodelsv2.model.Principal.wrap(item)
        }
        .toList
    override val action: List[Operation] = impl
      .action()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.primitives.Operation(item)
      }
      .toList
    override val condition
        : Option[Map[ConditionOperator, Map[ConditionKey, ConditionValue]]] =
      scala
        .Option(impl.condition())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lexmodelsv2.model.primitives
                .ConditionOperator(key) -> value.asScala
                .map({ case (key, value) =>
                  zio.aws.lexmodelsv2.model.primitives
                    .ConditionKey(key) -> zio.aws.lexmodelsv2.model.primitives
                    .ConditionValue(value)
                })
                .toMap
            })
            .toMap
        )
    override val expectedRevisionId: Option[RevisionId] = scala
      .Option(impl.expectedRevisionId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementRequest
  ): zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementRequest.ReadOnly =
    new Wrapper(impl)
}
