package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  RecommendedAction,
  LocaleName,
  Timestamp,
  FailureReason,
  ConfidenceThreshold,
  ResourceCount,
  Description,
  BotVersion,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeBotLocaleResponse(
    botId: Option[Id] = None,
    botVersion: Option[BotVersion] = None,
    localeId: Option[LocaleId] = None,
    localeName: Option[LocaleName] = None,
    description: Option[Description] = None,
    nluIntentConfidenceThreshold: Option[ConfidenceThreshold] = None,
    voiceSettings: Option[zio.aws.lexmodelsv2.model.VoiceSettings] = None,
    intentsCount: Option[ResourceCount] = None,
    slotTypesCount: Option[ResourceCount] = None,
    botLocaleStatus: Option[zio.aws.lexmodelsv2.model.BotLocaleStatus] = None,
    failureReasons: Option[Iterable[FailureReason]] = None,
    creationDateTime: Option[Timestamp] = None,
    lastUpdatedDateTime: Option[Timestamp] = None,
    lastBuildSubmittedDateTime: Option[Timestamp] = None,
    botLocaleHistoryEvents: Option[
      Iterable[zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent]
    ] = None,
    recommendedActions: Option[Iterable[RecommendedAction]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse = {
    import DescribeBotLocaleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        localeName.map(value => LocaleName.unwrap(value): java.lang.String)
      )(_.localeName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        nluIntentConfidenceThreshold.map(value =>
          ConfidenceThreshold.unwrap(value): java.lang.Double
        )
      )(_.nluIntentConfidenceThreshold)
      .optionallyWith(voiceSettings.map(value => value.buildAwsValue()))(
        _.voiceSettings
      )
      .optionallyWith(
        intentsCount.map(value => ResourceCount.unwrap(value): Integer)
      )(_.intentsCount)
      .optionallyWith(
        slotTypesCount.map(value => ResourceCount.unwrap(value): Integer)
      )(_.slotTypesCount)
      .optionallyWith(botLocaleStatus.map(value => value.unwrap))(
        _.botLocaleStatus
      )
      .optionallyWith(
        failureReasons.map(value =>
          value.map { item =>
            FailureReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failureReasons)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        lastBuildSubmittedDateTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.lastBuildSubmittedDateTime)
      .optionallyWith(
        botLocaleHistoryEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botLocaleHistoryEvents)
      .optionallyWith(
        recommendedActions.map(value =>
          value.map { item =>
            RecommendedAction.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.recommendedActions)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.wrap(buildAwsValue())
}
object DescribeBotLocaleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse =
      zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        localeName.map(value => value),
        description.map(value => value),
        nluIntentConfidenceThreshold.map(value => value),
        voiceSettings.map(value => value.asEditable),
        intentsCount.map(value => value),
        slotTypesCount.map(value => value),
        botLocaleStatus.map(value => value),
        failureReasons.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        lastBuildSubmittedDateTime.map(value => value),
        botLocaleHistoryEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendedActions.map(value => value)
      )
    def botId: Option[Id]
    def botVersion: Option[BotVersion]
    def localeId: Option[LocaleId]
    def localeName: Option[LocaleName]
    def description: Option[Description]
    def nluIntentConfidenceThreshold: Option[ConfidenceThreshold]
    def voiceSettings: Option[zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly]
    def intentsCount: Option[ResourceCount]
    def slotTypesCount: Option[ResourceCount]
    def botLocaleStatus: Option[zio.aws.lexmodelsv2.model.BotLocaleStatus]
    def failureReasons: Option[List[FailureReason]]
    def creationDateTime: Option[Timestamp]
    def lastUpdatedDateTime: Option[Timestamp]
    def lastBuildSubmittedDateTime: Option[Timestamp]
    def botLocaleHistoryEvents
        : Option[List[zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent.ReadOnly]]
    def recommendedActions: Option[List[RecommendedAction]]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getLocaleName: ZIO[Any, AwsError, LocaleName] =
      AwsError.unwrapOptionField("localeName", localeName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNluIntentConfidenceThreshold
        : ZIO[Any, AwsError, ConfidenceThreshold] = AwsError.unwrapOptionField(
      "nluIntentConfidenceThreshold",
      nluIntentConfidenceThreshold
    )
    def getVoiceSettings
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly] =
      AwsError.unwrapOptionField("voiceSettings", voiceSettings)
    def getIntentsCount: ZIO[Any, AwsError, ResourceCount] =
      AwsError.unwrapOptionField("intentsCount", intentsCount)
    def getSlotTypesCount: ZIO[Any, AwsError, ResourceCount] =
      AwsError.unwrapOptionField("slotTypesCount", slotTypesCount)
    def getBotLocaleStatus
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotLocaleStatus] =
      AwsError.unwrapOptionField("botLocaleStatus", botLocaleStatus)
    def getFailureReasons: ZIO[Any, AwsError, List[FailureReason]] =
      AwsError.unwrapOptionField("failureReasons", failureReasons)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getLastBuildSubmittedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "lastBuildSubmittedDateTime",
        lastBuildSubmittedDateTime
      )
    def getBotLocaleHistoryEvents: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "botLocaleHistoryEvents",
      botLocaleHistoryEvents
    )
    def getRecommendedActions: ZIO[Any, AwsError, List[RecommendedAction]] =
      AwsError.unwrapOptionField("recommendedActions", recommendedActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val localeName: Option[LocaleName] = scala
      .Option(impl.localeName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val nluIntentConfidenceThreshold: Option[ConfidenceThreshold] =
      scala
        .Option(impl.nluIntentConfidenceThreshold())
        .map(value =>
          zio.aws.lexmodelsv2.model.primitives.ConfidenceThreshold(value)
        )
    override val voiceSettings
        : Option[zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly] = scala
      .Option(impl.voiceSettings())
      .map(value => zio.aws.lexmodelsv2.model.VoiceSettings.wrap(value))
    override val intentsCount: Option[ResourceCount] = scala
      .Option(impl.intentsCount())
      .map(value => zio.aws.lexmodelsv2.model.primitives.ResourceCount(value))
    override val slotTypesCount: Option[ResourceCount] = scala
      .Option(impl.slotTypesCount())
      .map(value => zio.aws.lexmodelsv2.model.primitives.ResourceCount(value))
    override val botLocaleStatus
        : Option[zio.aws.lexmodelsv2.model.BotLocaleStatus] = scala
      .Option(impl.botLocaleStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotLocaleStatus.wrap(value))
    override val failureReasons: Option[List[FailureReason]] = scala
      .Option(impl.failureReasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.primitives.FailureReason(item)
        }.toList
      )
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastBuildSubmittedDateTime: Option[Timestamp] = scala
      .Option(impl.lastBuildSubmittedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val botLocaleHistoryEvents: Option[
      List[zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent.ReadOnly]
    ] = scala
      .Option(impl.botLocaleHistoryEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.BotLocaleHistoryEvent.wrap(item)
        }.toList
      )
    override val recommendedActions: Option[List[RecommendedAction]] = scala
      .Option(impl.recommendedActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.primitives.RecommendedAction(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse
  ): zio.aws.lexmodelsv2.model.DescribeBotLocaleResponse.ReadOnly = new Wrapper(
    impl
  )
}
