package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{RevisionId, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateResourcePolicyStatementResponse(
    resourceArn: Option[AmazonResourceName] = None,
    revisionId: Option[RevisionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementResponse = {
    import CreateResourcePolicyStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementResponse
      .builder()
      .optionallyWith(
        resourceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.resourceArn)
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementResponse
      .wrap(buildAwsValue())
}
object CreateResourcePolicyStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementResponse =
      zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementResponse(
        resourceArn.map(value => value),
        revisionId.map(value => value)
      )
    def resourceArn: Option[AmazonResourceName]
    def revisionId: Option[RevisionId]
    def getResourceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementResponse
  ) extends zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementResponse.ReadOnly {
    override val resourceArn: Option[AmazonResourceName] = scala
      .Option(impl.resourceArn())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.AmazonResourceName(value)
      )
    override val revisionId: Option[RevisionId] = scala
      .Option(impl.revisionId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateResourcePolicyStatementResponse
  ): zio.aws.lexmodelsv2.model.CreateResourcePolicyStatementResponse.ReadOnly =
    new Wrapper(impl)
}
