package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, Description, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateBotVersionRequest(
    botId: Id,
    description: Option[Description] = None,
    botVersionLocaleSpecification: Map[
      LocaleId,
      zio.aws.lexmodelsv2.model.BotVersionLocaleDetails
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest = {
    import CreateBotVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .botVersionLocaleSpecification(
        botVersionLocaleSpecification
          .map({ case (key, value) =>
            (LocaleId.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateBotVersionRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateBotVersionRequest.wrap(buildAwsValue())
}
object CreateBotVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateBotVersionRequest =
      zio.aws.lexmodelsv2.model.CreateBotVersionRequest(
        botId,
        description.map(value => value),
        botVersionLocaleSpecification.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def botId: Id
    def description: Option[Description]
    def botVersionLocaleSpecification: Map[
      LocaleId,
      zio.aws.lexmodelsv2.model.BotVersionLocaleDetails.ReadOnly
    ]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotVersionLocaleSpecification: ZIO[Any, Nothing, Map[
      LocaleId,
      zio.aws.lexmodelsv2.model.BotVersionLocaleDetails.ReadOnly
    ]] = ZIO.succeed(botVersionLocaleSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest
  ) extends zio.aws.lexmodelsv2.model.CreateBotVersionRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botVersionLocaleSpecification: Map[
      LocaleId,
      zio.aws.lexmodelsv2.model.BotVersionLocaleDetails.ReadOnly
    ] = impl
      .botVersionLocaleSpecification()
      .asScala
      .map({ case (key, value) =>
        zio.aws.lexmodelsv2.model.primitives.LocaleId(
          key
        ) -> zio.aws.lexmodelsv2.model.BotVersionLocaleDetails.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotVersionRequest
  ): zio.aws.lexmodelsv2.model.CreateBotVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
