package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  NumericalBotVersion,
  Description,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class BotSummary(
    botId: Option[Id] = None,
    botName: Option[Name] = None,
    description: Option[Description] = None,
    botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus] = None,
    latestBotVersion: Option[NumericalBotVersion] = None,
    lastUpdatedDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotSummary = {
    import BotSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotSummary
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(botStatus.map(value => value.unwrap))(_.botStatus)
      .optionallyWith(
        latestBotVersion.map(value =>
          NumericalBotVersion.unwrap(value): java.lang.String
        )
      )(_.latestBotVersion)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.BotSummary.wrap(buildAwsValue())
}
object BotSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotSummary =
      zio.aws.lexmodelsv2.model.BotSummary(
        botId.map(value => value),
        botName.map(value => value),
        description.map(value => value),
        botStatus.map(value => value),
        latestBotVersion.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def botId: Option[Id]
    def botName: Option[Name]
    def description: Option[Description]
    def botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus]
    def latestBotVersion: Option[NumericalBotVersion]
    def lastUpdatedDateTime: Option[Timestamp]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botName", botName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotStatus] =
      AwsError.unwrapOptionField("botStatus", botStatus)
    def getLatestBotVersion: ZIO[Any, AwsError, NumericalBotVersion] =
      AwsError.unwrapOptionField("latestBotVersion", latestBotVersion)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotSummary
  ) extends zio.aws.lexmodelsv2.model.BotSummary.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botName: Option[Name] = scala
      .Option(impl.botName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus] = scala
      .Option(impl.botStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotStatus.wrap(value))
    override val latestBotVersion: Option[NumericalBotVersion] = scala
      .Option(impl.latestBotVersion())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.NumericalBotVersion(value)
      )
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotSummary
  ): zio.aws.lexmodelsv2.model.BotSummary.ReadOnly = new Wrapper(impl)
}
