package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{Id, PriorityValue}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SlotPriority(priority: PriorityValue, slotId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotPriority = {
    import SlotPriority.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotPriority
      .builder()
      .priority(PriorityValue.unwrap(priority): Integer)
      .slotId(Id.unwrap(slotId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotPriority.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotPriority.wrap(buildAwsValue())
}
object SlotPriority {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotPriority
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotPriority =
      zio.aws.lexmodelsv2.model.SlotPriority(priority, slotId)
    def priority: PriorityValue
    def slotId: Id
    def getPriority: ZIO[Any, Nothing, PriorityValue] = ZIO.succeed(priority)
    def getSlotId: ZIO[Any, Nothing, Id] = ZIO.succeed(slotId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotPriority
  ) extends zio.aws.lexmodelsv2.model.SlotPriority.ReadOnly {
    override val priority: PriorityValue =
      zio.aws.lexmodelsv2.model.primitives.PriorityValue(impl.priority())
    override val slotId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.slotId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotPriority
  ): zio.aws.lexmodelsv2.model.SlotPriority.ReadOnly = new Wrapper(impl)
}
