package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  LocaleId,
  BotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListSlotsResponse(
    botId: Option[Id] = None,
    botVersion: Option[BotVersion] = None,
    localeId: Option[LocaleId] = None,
    intentId: Option[Id] = None,
    slotSummaries: Option[Iterable[zio.aws.lexmodelsv2.model.SlotSummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse = {
    import ListSlotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        intentId.map(value => Id.unwrap(value): java.lang.String)
      )(_.intentId)
      .optionallyWith(
        slotSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.slotSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListSlotsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListSlotsResponse.wrap(buildAwsValue())
}
object ListSlotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListSlotsResponse =
      zio.aws.lexmodelsv2.model.ListSlotsResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        intentId.map(value => value),
        slotSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def botId: Option[Id]
    def botVersion: Option[BotVersion]
    def localeId: Option[LocaleId]
    def intentId: Option[Id]
    def slotSummaries
        : Option[List[zio.aws.lexmodelsv2.model.SlotSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getIntentId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("intentId", intentId)
    def getSlotSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SlotSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("slotSummaries", slotSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse
  ) extends zio.aws.lexmodelsv2.model.ListSlotsResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val intentId: Option[Id] = scala
      .Option(impl.intentId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val slotSummaries
        : Option[List[zio.aws.lexmodelsv2.model.SlotSummary.ReadOnly]] = scala
      .Option(impl.slotSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.SlotSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse
  ): zio.aws.lexmodelsv2.model.ListSlotsResponse.ReadOnly = new Wrapper(impl)
}
