package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{FilePassword, KmsKeyArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EncryptionSetting(
    kmsKeyArn: Option[KmsKeyArn] = None,
    botLocaleExportPassword: Option[FilePassword] = None,
    associatedTranscriptsPassword: Option[FilePassword] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.EncryptionSetting = {
    import EncryptionSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.EncryptionSetting
      .builder()
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(
        botLocaleExportPassword.map(value =>
          FilePassword.unwrap(value): java.lang.String
        )
      )(_.botLocaleExportPassword)
      .optionallyWith(
        associatedTranscriptsPassword.map(value =>
          FilePassword.unwrap(value): java.lang.String
        )
      )(_.associatedTranscriptsPassword)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly =
    zio.aws.lexmodelsv2.model.EncryptionSetting.wrap(buildAwsValue())
}
object EncryptionSetting {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.EncryptionSetting
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.EncryptionSetting =
      zio.aws.lexmodelsv2.model.EncryptionSetting(
        kmsKeyArn.map(value => value),
        botLocaleExportPassword.map(value => value),
        associatedTranscriptsPassword.map(value => value)
      )
    def kmsKeyArn: Option[KmsKeyArn]
    def botLocaleExportPassword: Option[FilePassword]
    def associatedTranscriptsPassword: Option[FilePassword]
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getBotLocaleExportPassword: ZIO[Any, AwsError, FilePassword] = AwsError
      .unwrapOptionField("botLocaleExportPassword", botLocaleExportPassword)
    def getAssociatedTranscriptsPassword: ZIO[Any, AwsError, FilePassword] =
      AwsError.unwrapOptionField(
        "associatedTranscriptsPassword",
        associatedTranscriptsPassword
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.EncryptionSetting
  ) extends zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly {
    override val kmsKeyArn: Option[KmsKeyArn] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.KmsKeyArn(value))
    override val botLocaleExportPassword: Option[FilePassword] = scala
      .Option(impl.botLocaleExportPassword())
      .map(value => zio.aws.lexmodelsv2.model.primitives.FilePassword(value))
    override val associatedTranscriptsPassword: Option[FilePassword] = scala
      .Option(impl.associatedTranscriptsPassword())
      .map(value => zio.aws.lexmodelsv2.model.primitives.FilePassword(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.EncryptionSetting
  ): zio.aws.lexmodelsv2.model.EncryptionSetting.ReadOnly = new Wrapper(impl)
}
