package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  Description,
  Name,
  BuiltInOrCustomSlotTypeId,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SlotSummary(
    slotId: Option[Id] = None,
    slotName: Option[Name] = None,
    description: Option[Description] = None,
    slotConstraint: Option[zio.aws.lexmodelsv2.model.SlotConstraint] = None,
    slotTypeId: Option[BuiltInOrCustomSlotTypeId] = None,
    valueElicitationPromptSpecification: Option[
      zio.aws.lexmodelsv2.model.PromptSpecification
    ] = None,
    lastUpdatedDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotSummary = {
    import SlotSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SlotSummary
      .builder()
      .optionallyWith(slotId.map(value => Id.unwrap(value): java.lang.String))(
        _.slotId
      )
      .optionallyWith(
        slotName.map(value => Name.unwrap(value): java.lang.String)
      )(_.slotName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(slotConstraint.map(value => value.unwrap))(
        _.slotConstraint
      )
      .optionallyWith(
        slotTypeId.map(value =>
          BuiltInOrCustomSlotTypeId.unwrap(value): java.lang.String
        )
      )(_.slotTypeId)
      .optionallyWith(
        valueElicitationPromptSpecification.map(value => value.buildAwsValue())
      )(_.valueElicitationPromptSpecification)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.SlotSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.SlotSummary.wrap(buildAwsValue())
}
object SlotSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SlotSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.SlotSummary =
      zio.aws.lexmodelsv2.model.SlotSummary(
        slotId.map(value => value),
        slotName.map(value => value),
        description.map(value => value),
        slotConstraint.map(value => value),
        slotTypeId.map(value => value),
        valueElicitationPromptSpecification.map(value => value.asEditable),
        lastUpdatedDateTime.map(value => value)
      )
    def slotId: Option[Id]
    def slotName: Option[Name]
    def description: Option[Description]
    def slotConstraint: Option[zio.aws.lexmodelsv2.model.SlotConstraint]
    def slotTypeId: Option[BuiltInOrCustomSlotTypeId]
    def valueElicitationPromptSpecification
        : Option[zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly]
    def lastUpdatedDateTime: Option[Timestamp]
    def getSlotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("slotId", slotId)
    def getSlotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("slotName", slotName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSlotConstraint
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.SlotConstraint] =
      AwsError.unwrapOptionField("slotConstraint", slotConstraint)
    def getSlotTypeId: ZIO[Any, AwsError, BuiltInOrCustomSlotTypeId] =
      AwsError.unwrapOptionField("slotTypeId", slotTypeId)
    def getValueElicitationPromptSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "valueElicitationPromptSpecification",
      valueElicitationPromptSpecification
    )
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotSummary
  ) extends zio.aws.lexmodelsv2.model.SlotSummary.ReadOnly {
    override val slotId: Option[Id] = scala
      .Option(impl.slotId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val slotName: Option[Name] = scala
      .Option(impl.slotName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val slotConstraint
        : Option[zio.aws.lexmodelsv2.model.SlotConstraint] = scala
      .Option(impl.slotConstraint())
      .map(value => zio.aws.lexmodelsv2.model.SlotConstraint.wrap(value))
    override val slotTypeId: Option[BuiltInOrCustomSlotTypeId] = scala
      .Option(impl.slotTypeId())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.BuiltInOrCustomSlotTypeId(value)
      )
    override val valueElicitationPromptSpecification
        : Option[zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly] = scala
      .Option(impl.valueElicitationPromptSpecification())
      .map(value => zio.aws.lexmodelsv2.model.PromptSpecification.wrap(value))
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SlotSummary
  ): zio.aws.lexmodelsv2.model.SlotSummary.ReadOnly = new Wrapper(impl)
}
