package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{BoxedBoolean, PromptMaxRetries}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PromptSpecification(
    messageGroups: Iterable[zio.aws.lexmodelsv2.model.MessageGroup],
    maxRetries: PromptMaxRetries,
    allowInterrupt: Option[BoxedBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification = {
    import PromptSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification
      .builder()
      .messageGroups(messageGroups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .maxRetries(PromptMaxRetries.unwrap(maxRetries): Integer)
      .optionallyWith(
        allowInterrupt.map(value =>
          BoxedBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.allowInterrupt)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.PromptSpecification.wrap(buildAwsValue())
}
object PromptSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.PromptSpecification =
      zio.aws.lexmodelsv2.model.PromptSpecification(
        messageGroups.map { item =>
          item.asEditable
        },
        maxRetries,
        allowInterrupt.map(value => value)
      )
    def messageGroups: List[zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly]
    def maxRetries: PromptMaxRetries
    def allowInterrupt: Option[BoxedBoolean]
    def getMessageGroups: ZIO[Any, Nothing, List[
      zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly
    ]] = ZIO.succeed(messageGroups)
    def getMaxRetries: ZIO[Any, Nothing, PromptMaxRetries] =
      ZIO.succeed(maxRetries)
    def getAllowInterrupt: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("allowInterrupt", allowInterrupt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification
  ) extends zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly {
    override val messageGroups
        : List[zio.aws.lexmodelsv2.model.MessageGroup.ReadOnly] = impl
      .messageGroups()
      .asScala
      .map { item =>
        zio.aws.lexmodelsv2.model.MessageGroup.wrap(item)
      }
      .toList
    override val maxRetries: PromptMaxRetries =
      zio.aws.lexmodelsv2.model.primitives.PromptMaxRetries(impl.maxRetries())
    override val allowInterrupt: Option[BoxedBoolean] = scala
      .Option(impl.allowInterrupt())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BoxedBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.PromptSpecification
  ): zio.aws.lexmodelsv2.model.PromptSpecification.ReadOnly = new Wrapper(impl)
}
