package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LogPrefix, CloudWatchLogGroupArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloudWatchLogGroupLogDestination(
    cloudWatchLogGroupArn: CloudWatchLogGroupArn,
    logPrefix: LogPrefix
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CloudWatchLogGroupLogDestination = {
    import CloudWatchLogGroupLogDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CloudWatchLogGroupLogDestination
      .builder()
      .cloudWatchLogGroupArn(
        CloudWatchLogGroupArn.unwrap(cloudWatchLogGroupArn): java.lang.String
      )
      .logPrefix(LogPrefix.unwrap(logPrefix): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.CloudWatchLogGroupLogDestination.ReadOnly =
    zio.aws.lexmodelsv2.model.CloudWatchLogGroupLogDestination
      .wrap(buildAwsValue())
}
object CloudWatchLogGroupLogDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CloudWatchLogGroupLogDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CloudWatchLogGroupLogDestination =
      zio.aws.lexmodelsv2.model
        .CloudWatchLogGroupLogDestination(cloudWatchLogGroupArn, logPrefix)
    def cloudWatchLogGroupArn: CloudWatchLogGroupArn
    def logPrefix: LogPrefix
    def getCloudWatchLogGroupArn: ZIO[Any, Nothing, CloudWatchLogGroupArn] =
      ZIO.succeed(cloudWatchLogGroupArn)
    def getLogPrefix: ZIO[Any, Nothing, LogPrefix] = ZIO.succeed(logPrefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CloudWatchLogGroupLogDestination
  ) extends zio.aws.lexmodelsv2.model.CloudWatchLogGroupLogDestination.ReadOnly {
    override val cloudWatchLogGroupArn: CloudWatchLogGroupArn =
      zio.aws.lexmodelsv2.model.primitives
        .CloudWatchLogGroupArn(impl.cloudWatchLogGroupArn())
    override val logPrefix: LogPrefix =
      zio.aws.lexmodelsv2.model.primitives.LogPrefix(impl.logPrefix())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CloudWatchLogGroupLogDestination
  ): zio.aws.lexmodelsv2.model.CloudWatchLogGroupLogDestination.ReadOnly =
    new Wrapper(impl)
}
