package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  Timestamp,
  SlotTypeSignature,
  Description,
  BotVersion,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeSlotTypeResponse(
    slotTypeId: Option[Id] = None,
    slotTypeName: Option[Name] = None,
    description: Option[Description] = None,
    slotTypeValues: Option[Iterable[zio.aws.lexmodelsv2.model.SlotTypeValue]] =
      None,
    valueSelectionSetting: Option[
      zio.aws.lexmodelsv2.model.SlotValueSelectionSetting
    ] = None,
    parentSlotTypeSignature: Option[SlotTypeSignature] = None,
    botId: Option[Id] = None,
    botVersion: Option[BotVersion] = None,
    localeId: Option[LocaleId] = None,
    creationDateTime: Option[Timestamp] = None,
    lastUpdatedDateTime: Option[Timestamp] = None,
    externalSourceSetting: Option[
      zio.aws.lexmodelsv2.model.ExternalSourceSetting
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse = {
    import DescribeSlotTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse
      .builder()
      .optionallyWith(
        slotTypeId.map(value => Id.unwrap(value): java.lang.String)
      )(_.slotTypeId)
      .optionallyWith(
        slotTypeName.map(value => Name.unwrap(value): java.lang.String)
      )(_.slotTypeName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        slotTypeValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.slotTypeValues)
      .optionallyWith(
        valueSelectionSetting.map(value => value.buildAwsValue())
      )(_.valueSelectionSetting)
      .optionallyWith(
        parentSlotTypeSignature.map(value =>
          SlotTypeSignature.unwrap(value): java.lang.String
        )
      )(_.parentSlotTypeSignature)
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .optionallyWith(
        externalSourceSetting.map(value => value.buildAwsValue())
      )(_.externalSourceSetting)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeSlotTypeResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeSlotTypeResponse.wrap(buildAwsValue())
}
object DescribeSlotTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeSlotTypeResponse =
      zio.aws.lexmodelsv2.model.DescribeSlotTypeResponse(
        slotTypeId.map(value => value),
        slotTypeName.map(value => value),
        description.map(value => value),
        slotTypeValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        valueSelectionSetting.map(value => value.asEditable),
        parentSlotTypeSignature.map(value => value),
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value),
        externalSourceSetting.map(value => value.asEditable)
      )
    def slotTypeId: Option[Id]
    def slotTypeName: Option[Name]
    def description: Option[Description]
    def slotTypeValues
        : Option[List[zio.aws.lexmodelsv2.model.SlotTypeValue.ReadOnly]]
    def valueSelectionSetting
        : Option[zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.ReadOnly]
    def parentSlotTypeSignature: Option[SlotTypeSignature]
    def botId: Option[Id]
    def botVersion: Option[BotVersion]
    def localeId: Option[LocaleId]
    def creationDateTime: Option[Timestamp]
    def lastUpdatedDateTime: Option[Timestamp]
    def externalSourceSetting
        : Option[zio.aws.lexmodelsv2.model.ExternalSourceSetting.ReadOnly]
    def getSlotTypeId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("slotTypeId", slotTypeId)
    def getSlotTypeName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("slotTypeName", slotTypeName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSlotTypeValues: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.SlotTypeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("slotTypeValues", slotTypeValues)
    def getValueSelectionSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.ReadOnly
    ] =
      AwsError.unwrapOptionField("valueSelectionSetting", valueSelectionSetting)
    def getParentSlotTypeSignature: ZIO[Any, AwsError, SlotTypeSignature] =
      AwsError.unwrapOptionField(
        "parentSlotTypeSignature",
        parentSlotTypeSignature
      )
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
    def getExternalSourceSetting: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.ExternalSourceSetting.ReadOnly
    ] =
      AwsError.unwrapOptionField("externalSourceSetting", externalSourceSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeSlotTypeResponse.ReadOnly {
    override val slotTypeId: Option[Id] = scala
      .Option(impl.slotTypeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val slotTypeName: Option[Name] = scala
      .Option(impl.slotTypeName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val slotTypeValues
        : Option[List[zio.aws.lexmodelsv2.model.SlotTypeValue.ReadOnly]] = scala
      .Option(impl.slotTypeValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.SlotTypeValue.wrap(item)
        }.toList
      )
    override val valueSelectionSetting
        : Option[zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.ReadOnly] =
      scala
        .Option(impl.valueSelectionSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.SlotValueSelectionSetting.wrap(value)
        )
    override val parentSlotTypeSignature: Option[SlotTypeSignature] = scala
      .Option(impl.parentSlotTypeSignature())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.SlotTypeSignature(value)
      )
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val externalSourceSetting
        : Option[zio.aws.lexmodelsv2.model.ExternalSourceSetting.ReadOnly] =
      scala
        .Option(impl.externalSourceSetting())
        .map(value =>
          zio.aws.lexmodelsv2.model.ExternalSourceSetting.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeSlotTypeResponse
  ): zio.aws.lexmodelsv2.model.DescribeSlotTypeResponse.ReadOnly = new Wrapper(
    impl
  )
}
