package zio.aws.lexmodelsv2.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lexmodelsv2.model.primitives.{
  RoleArn,
  Timestamp,
  SessionTTL,
  Description,
  Name,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeBotResponse(
    botId: Option[Id] = None,
    botName: Option[Name] = None,
    description: Option[Description] = None,
    roleArn: Option[RoleArn] = None,
    dataPrivacy: Option[zio.aws.lexmodelsv2.model.DataPrivacy] = None,
    idleSessionTTLInSeconds: Option[SessionTTL] = None,
    botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus] = None,
    creationDateTime: Option[Timestamp] = None,
    lastUpdatedDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse = {
    import DescribeBotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(dataPrivacy.map(value => value.buildAwsValue()))(
        _.dataPrivacy
      )
      .optionallyWith(
        idleSessionTTLInSeconds.map(value => SessionTTL.unwrap(value): Integer)
      )(_.idleSessionTTLInSeconds)
      .optionallyWith(botStatus.map(value => value.unwrap))(_.botStatus)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        lastUpdatedDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DescribeBotResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DescribeBotResponse.wrap(buildAwsValue())
}
object DescribeBotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DescribeBotResponse =
      zio.aws.lexmodelsv2.model.DescribeBotResponse(
        botId.map(value => value),
        botName.map(value => value),
        description.map(value => value),
        roleArn.map(value => value),
        dataPrivacy.map(value => value.asEditable),
        idleSessionTTLInSeconds.map(value => value),
        botStatus.map(value => value),
        creationDateTime.map(value => value),
        lastUpdatedDateTime.map(value => value)
      )
    def botId: Option[Id]
    def botName: Option[Name]
    def description: Option[Description]
    def roleArn: Option[RoleArn]
    def dataPrivacy: Option[zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly]
    def idleSessionTTLInSeconds: Option[SessionTTL]
    def botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus]
    def creationDateTime: Option[Timestamp]
    def lastUpdatedDateTime: Option[Timestamp]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botName", botName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDataPrivacy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly] =
      AwsError.unwrapOptionField("dataPrivacy", dataPrivacy)
    def getIdleSessionTTLInSeconds: ZIO[Any, AwsError, SessionTTL] = AwsError
      .unwrapOptionField("idleSessionTTLInSeconds", idleSessionTTLInSeconds)
    def getBotStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotStatus] =
      AwsError.unwrapOptionField("botStatus", botStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getLastUpdatedDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDateTime", lastUpdatedDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse
  ) extends zio.aws.lexmodelsv2.model.DescribeBotResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botName: Option[Name] = scala
      .Option(impl.botName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RoleArn(value))
    override val dataPrivacy
        : Option[zio.aws.lexmodelsv2.model.DataPrivacy.ReadOnly] = scala
      .Option(impl.dataPrivacy())
      .map(value => zio.aws.lexmodelsv2.model.DataPrivacy.wrap(value))
    override val idleSessionTTLInSeconds: Option[SessionTTL] = scala
      .Option(impl.idleSessionTTLInSeconds())
      .map(value => zio.aws.lexmodelsv2.model.primitives.SessionTTL(value))
    override val botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus] = scala
      .Option(impl.botStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotStatus.wrap(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
    override val lastUpdatedDateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse
  ): zio.aws.lexmodelsv2.model.DescribeBotResponse.ReadOnly = new Wrapper(impl)
}
