package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  ConfidenceThreshold,
  DraftBotVersion,
  Description,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateBotLocaleRequest(
    botId: Id,
    botVersion: DraftBotVersion,
    localeId: LocaleId,
    description: Option[Description] = None,
    nluIntentConfidenceThreshold: ConfidenceThreshold,
    voiceSettings: Option[zio.aws.lexmodelsv2.model.VoiceSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest = {
    import CreateBotLocaleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .botVersion(DraftBotVersion.unwrap(botVersion): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .nluIntentConfidenceThreshold(
        ConfidenceThreshold.unwrap(
          nluIntentConfidenceThreshold
        ): java.lang.Double
      )
      .optionallyWith(voiceSettings.map(value => value.buildAwsValue()))(
        _.voiceSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.CreateBotLocaleRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.CreateBotLocaleRequest.wrap(buildAwsValue())
}
object CreateBotLocaleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.CreateBotLocaleRequest =
      zio.aws.lexmodelsv2.model.CreateBotLocaleRequest(
        botId,
        botVersion,
        localeId,
        description.map(value => value),
        nluIntentConfidenceThreshold,
        voiceSettings.map(value => value.asEditable)
      )
    def botId: Id
    def botVersion: DraftBotVersion
    def localeId: LocaleId
    def description: Option[Description]
    def nluIntentConfidenceThreshold: ConfidenceThreshold
    def voiceSettings: Option[zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getBotVersion: ZIO[Any, Nothing, DraftBotVersion] =
      ZIO.succeed(botVersion)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNluIntentConfidenceThreshold
        : ZIO[Any, Nothing, ConfidenceThreshold] =
      ZIO.succeed(nluIntentConfidenceThreshold)
    def getVoiceSettings
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly] =
      AwsError.unwrapOptionField("voiceSettings", voiceSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest
  ) extends zio.aws.lexmodelsv2.model.CreateBotLocaleRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val botVersion: DraftBotVersion =
      zio.aws.lexmodelsv2.model.primitives.DraftBotVersion(impl.botVersion())
    override val localeId: LocaleId =
      zio.aws.lexmodelsv2.model.primitives.LocaleId(impl.localeId())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val nluIntentConfidenceThreshold: ConfidenceThreshold =
      zio.aws.lexmodelsv2.model.primitives
        .ConfidenceThreshold(impl.nluIntentConfidenceThreshold())
    override val voiceSettings
        : Option[zio.aws.lexmodelsv2.model.VoiceSettings.ReadOnly] = scala
      .Option(impl.voiceSettings())
      .map(value => zio.aws.lexmodelsv2.model.VoiceSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.CreateBotLocaleRequest
  ): zio.aws.lexmodelsv2.model.CreateBotLocaleRequest.ReadOnly = new Wrapper(
    impl
  )
}
