package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait SlotTypeFilterName {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilterName
}
object SlotTypeFilterName {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilterName
  ): zio.aws.lexmodelsv2.model.SlotTypeFilterName = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilterName.SLOT_TYPE_NAME =>
      val r = SlotTypeName
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilterName.EXTERNAL_SOURCE_TYPE =>
      val r = ExternalSourceType
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.SlotTypeFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object SlotTypeName
      extends zio.aws.lexmodelsv2.model.SlotTypeFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilterName.SLOT_TYPE_NAME
  }
  case object ExternalSourceType
      extends zio.aws.lexmodelsv2.model.SlotTypeFilterName {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilterName =
      software.amazon.awssdk.services.lexmodelsv2.model.SlotTypeFilterName.EXTERNAL_SOURCE_TYPE
  }
}
