package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  NextToken,
  MaxResults,
  BotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListExportsRequest(
    botId: Option[Id] = None,
    botVersion: Option[BotVersion] = None,
    sortBy: Option[zio.aws.lexmodelsv2.model.ExportSortBy] = None,
    filters: Option[Iterable[zio.aws.lexmodelsv2.model.ExportFilter]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest = {
    import ListExportsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListExportsRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.ListExportsRequest.wrap(buildAwsValue())
}
object ListExportsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListExportsRequest =
      zio.aws.lexmodelsv2.model.ListExportsRequest(
        botId.map(value => value),
        botVersion.map(value => value),
        sortBy.map(value => value.asEditable),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def botId: Option[Id]
    def botVersion: Option[BotVersion]
    def sortBy: Option[zio.aws.lexmodelsv2.model.ExportSortBy.ReadOnly]
    def filters: Option[List[zio.aws.lexmodelsv2.model.ExportFilter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.ExportSortBy.ReadOnly] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.ExportFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest
  ) extends zio.aws.lexmodelsv2.model.ListExportsRequest.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val sortBy
        : Option[zio.aws.lexmodelsv2.model.ExportSortBy.ReadOnly] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.lexmodelsv2.model.ExportSortBy.wrap(value))
    override val filters
        : Option[List[zio.aws.lexmodelsv2.model.ExportFilter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.ExportFilter.wrap(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListExportsRequest
  ): zio.aws.lexmodelsv2.model.ListExportsRequest.ReadOnly = new Wrapper(impl)
}
