package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{RevisionId, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteResourcePolicyRequest(
    resourceArn: AmazonResourceName,
    expectedRevisionId: Option[RevisionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyRequest = {
    import DeleteResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .optionallyWith(
        expectedRevisionId.map(value =>
          RevisionId.unwrap(value): java.lang.String
        )
      )(_.expectedRevisionId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.DeleteResourcePolicyRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteResourcePolicyRequest.wrap(buildAwsValue())
}
object DeleteResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteResourcePolicyRequest =
      zio.aws.lexmodelsv2.model.DeleteResourcePolicyRequest(
        resourceArn,
        expectedRevisionId.map(value => value)
      )
    def resourceArn: AmazonResourceName
    def expectedRevisionId: Option[RevisionId]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getExpectedRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("expectedRevisionId", expectedRevisionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteResourcePolicyRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.lexmodelsv2.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val expectedRevisionId: Option[RevisionId] = scala
      .Option(impl.expectedRevisionId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.RevisionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteResourcePolicyRequest
  ): zio.aws.lexmodelsv2.model.DeleteResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
