package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{
  Timestamp,
  Description,
  BotVersion,
  Name
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class BotVersionSummary(
    botName: Option[Name] = None,
    botVersion: Option[BotVersion] = None,
    description: Option[Description] = None,
    botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus] = None,
    creationDateTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary = {
    import BotVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary
      .builder()
      .optionallyWith(
        botName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botName)
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(botStatus.map(value => value.unwrap))(_.botStatus)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.BotVersionSummary.ReadOnly =
    zio.aws.lexmodelsv2.model.BotVersionSummary.wrap(buildAwsValue())
}
object BotVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.BotVersionSummary =
      zio.aws.lexmodelsv2.model.BotVersionSummary(
        botName.map(value => value),
        botVersion.map(value => value),
        description.map(value => value),
        botStatus.map(value => value),
        creationDateTime.map(value => value)
      )
    def botName: Option[Name]
    def botVersion: Option[BotVersion]
    def description: Option[Description]
    def botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus]
    def creationDateTime: Option[Timestamp]
    def getBotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botName", botName)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getBotStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotStatus] =
      AwsError.unwrapOptionField("botStatus", botStatus)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary
  ) extends zio.aws.lexmodelsv2.model.BotVersionSummary.ReadOnly {
    override val botName: Option[Name] = scala
      .Option(impl.botName())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Name(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Description(value))
    override val botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus] = scala
      .Option(impl.botStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotStatus.wrap(value))
    override val creationDateTime: Option[Timestamp] = scala
      .Option(impl.creationDateTime())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.BotVersionSummary
  ): zio.aws.lexmodelsv2.model.BotVersionSummary.ReadOnly = new Wrapper(impl)
}
