package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{LocaleId, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBuiltInSlotTypesResponse(
    builtInSlotTypeSummaries: Option[
      Iterable[zio.aws.lexmodelsv2.model.BuiltInSlotTypeSummary]
    ] = None,
    nextToken: Option[NextToken] = None,
    localeId: Option[LocaleId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse = {
    import ListBuiltInSlotTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse
      .builder()
      .optionallyWith(
        builtInSlotTypeSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.builtInSlotTypeSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesResponse.wrap(buildAwsValue())
}
object ListBuiltInSlotTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesResponse =
      zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesResponse(
        builtInSlotTypeSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        localeId.map(value => value)
      )
    def builtInSlotTypeSummaries: Option[
      List[zio.aws.lexmodelsv2.model.BuiltInSlotTypeSummary.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def localeId: Option[LocaleId]
    def getBuiltInSlotTypeSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BuiltInSlotTypeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "builtInSlotTypeSummaries",
      builtInSlotTypeSummaries
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse
  ) extends zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesResponse.ReadOnly {
    override val builtInSlotTypeSummaries: Option[
      List[zio.aws.lexmodelsv2.model.BuiltInSlotTypeSummary.ReadOnly]
    ] = scala
      .Option(impl.builtInSlotTypeSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.BuiltInSlotTypeSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBuiltInSlotTypesResponse
  ): zio.aws.lexmodelsv2.model.ListBuiltInSlotTypesResponse.ReadOnly =
    new Wrapper(impl)
}
