package zio.aws.lexmodelsv2.model
import scala.jdk.CollectionConverters._
sealed trait ExportFilterOperator {
  def unwrap
      : software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterOperator
}
object ExportFilterOperator {
  def wrap(
      value: software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterOperator
  ): zio.aws.lexmodelsv2.model.ExportFilterOperator = value match {
    case software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterOperator.CO =>
      val r = CO
      r
    case software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterOperator.EQ =>
      val r = EQ
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexmodelsv2.model.ExportFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterOperator =
      software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object CO extends zio.aws.lexmodelsv2.model.ExportFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterOperator =
      software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterOperator.CO
  }
  case object EQ extends zio.aws.lexmodelsv2.model.ExportFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterOperator =
      software.amazon.awssdk.services.lexmodelsv2.model.ExportFilterOperator.EQ
  }
}
