package zio.aws.lexmodelsv2.model
import java.lang.Integer
import zio.aws.lexmodelsv2.model.primitives.{
  LocaleId,
  NextIndex,
  MaxResults,
  BotVersion,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchAssociatedTranscriptsResponse(
    botId: Option[Id] = None,
    botVersion: Option[BotVersion] = None,
    localeId: Option[LocaleId] = None,
    botRecommendationId: Option[Id] = None,
    nextIndex: Option[NextIndex] = None,
    associatedTranscripts: Option[
      Iterable[zio.aws.lexmodelsv2.model.AssociatedTranscript]
    ] = None,
    totalResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsResponse = {
    import SearchAssociatedTranscriptsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        botRecommendationId.map(value => Id.unwrap(value): java.lang.String)
      )(_.botRecommendationId)
      .optionallyWith(nextIndex.map(value => NextIndex.unwrap(value): Integer))(
        _.nextIndex
      )
      .optionallyWith(
        associatedTranscripts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedTranscripts)
      .optionallyWith(
        totalResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.totalResults)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsResponse
      .wrap(buildAwsValue())
}
object SearchAssociatedTranscriptsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsResponse =
      zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        localeId.map(value => value),
        botRecommendationId.map(value => value),
        nextIndex.map(value => value),
        associatedTranscripts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalResults.map(value => value)
      )
    def botId: Option[Id]
    def botVersion: Option[BotVersion]
    def localeId: Option[LocaleId]
    def botRecommendationId: Option[Id]
    def nextIndex: Option[NextIndex]
    def associatedTranscripts
        : Option[List[zio.aws.lexmodelsv2.model.AssociatedTranscript.ReadOnly]]
    def totalResults: Option[MaxResults]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getBotRecommendationId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botRecommendationId", botRecommendationId)
    def getNextIndex: ZIO[Any, AwsError, NextIndex] =
      AwsError.unwrapOptionField("nextIndex", nextIndex)
    def getAssociatedTranscripts: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.AssociatedTranscript.ReadOnly
    ]] =
      AwsError.unwrapOptionField("associatedTranscripts", associatedTranscripts)
    def getTotalResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("totalResults", totalResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsResponse
  ) extends zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexmodelsv2.model.primitives.BotVersion(value))
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.LocaleId(value))
    override val botRecommendationId: Option[Id] = scala
      .Option(impl.botRecommendationId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val nextIndex: Option[NextIndex] = scala
      .Option(impl.nextIndex())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextIndex(value))
    override val associatedTranscripts: Option[
      List[zio.aws.lexmodelsv2.model.AssociatedTranscript.ReadOnly]
    ] = scala
      .Option(impl.associatedTranscripts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexmodelsv2.model.AssociatedTranscript.wrap(item)
        }.toList
      )
    override val totalResults: Option[MaxResults] = scala
      .Option(impl.totalResults())
      .map(value => zio.aws.lexmodelsv2.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.SearchAssociatedTranscriptsResponse
  ): zio.aws.lexmodelsv2.model.SearchAssociatedTranscriptsResponse.ReadOnly =
    new Wrapper(impl)
}
