package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{Id, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListBotAliasesResponse(
    botAliasSummaries: Option[
      Iterable[zio.aws.lexmodelsv2.model.BotAliasSummary]
    ] = None,
    nextToken: Option[NextToken] = None,
    botId: Option[Id] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse = {
    import ListBotAliasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse
      .builder()
      .optionallyWith(
        botAliasSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.botAliasSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.ListBotAliasesResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.ListBotAliasesResponse.wrap(buildAwsValue())
}
object ListBotAliasesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ListBotAliasesResponse =
      zio.aws.lexmodelsv2.model.ListBotAliasesResponse(
        botAliasSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        botId.map(value => value)
      )
    def botAliasSummaries
        : Option[List[zio.aws.lexmodelsv2.model.BotAliasSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def botId: Option[Id]
    def getBotAliasSummaries: ZIO[Any, AwsError, List[
      zio.aws.lexmodelsv2.model.BotAliasSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("botAliasSummaries", botAliasSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse
  ) extends zio.aws.lexmodelsv2.model.ListBotAliasesResponse.ReadOnly {
    override val botAliasSummaries
        : Option[List[zio.aws.lexmodelsv2.model.BotAliasSummary.ReadOnly]] =
      scala
        .Option(impl.botAliasSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexmodelsv2.model.BotAliasSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.lexmodelsv2.model.primitives.NextToken(value))
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ListBotAliasesResponse
  ): zio.aws.lexmodelsv2.model.ListBotAliasesResponse.ReadOnly = new Wrapper(
    impl
  )
}
