package zio.aws.lexmodelsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportResourceSpecification(
    botImportSpecification: Option[
      zio.aws.lexmodelsv2.model.BotImportSpecification
    ] = None,
    botLocaleImportSpecification: Option[
      zio.aws.lexmodelsv2.model.BotLocaleImportSpecification
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification = {
    import ImportResourceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification
      .builder()
      .optionallyWith(
        botImportSpecification.map(value => value.buildAwsValue())
      )(_.botImportSpecification)
      .optionallyWith(
        botLocaleImportSpecification.map(value => value.buildAwsValue())
      )(_.botLocaleImportSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly =
    zio.aws.lexmodelsv2.model.ImportResourceSpecification.wrap(buildAwsValue())
}
object ImportResourceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.ImportResourceSpecification =
      zio.aws.lexmodelsv2.model.ImportResourceSpecification(
        botImportSpecification.map(value => value.asEditable),
        botLocaleImportSpecification.map(value => value.asEditable)
      )
    def botImportSpecification
        : Option[zio.aws.lexmodelsv2.model.BotImportSpecification.ReadOnly]
    def botLocaleImportSpecification: Option[
      zio.aws.lexmodelsv2.model.BotLocaleImportSpecification.ReadOnly
    ]
    def getBotImportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotImportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "botImportSpecification",
      botImportSpecification
    )
    def getBotLocaleImportSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.lexmodelsv2.model.BotLocaleImportSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "botLocaleImportSpecification",
      botLocaleImportSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification
  ) extends zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly {
    override val botImportSpecification
        : Option[zio.aws.lexmodelsv2.model.BotImportSpecification.ReadOnly] =
      scala
        .Option(impl.botImportSpecification())
        .map(value =>
          zio.aws.lexmodelsv2.model.BotImportSpecification.wrap(value)
        )
    override val botLocaleImportSpecification: Option[
      zio.aws.lexmodelsv2.model.BotLocaleImportSpecification.ReadOnly
    ] = scala
      .Option(impl.botLocaleImportSpecification())
      .map(value =>
        zio.aws.lexmodelsv2.model.BotLocaleImportSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.ImportResourceSpecification
  ): zio.aws.lexmodelsv2.model.ImportResourceSpecification.ReadOnly =
    new Wrapper(impl)
}
