package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{NumericalBotVersion, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteBotVersionResponse(
    botId: Option[Id] = None,
    botVersion: Option[NumericalBotVersion] = None,
    botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse = {
    import DeleteBotVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse
      .builder()
      .optionallyWith(botId.map(value => Id.unwrap(value): java.lang.String))(
        _.botId
      )
      .optionallyWith(
        botVersion.map(value =>
          NumericalBotVersion.unwrap(value): java.lang.String
        )
      )(_.botVersion)
      .optionallyWith(botStatus.map(value => value.unwrap))(_.botStatus)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.wrap(buildAwsValue())
}
object DeleteBotVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteBotVersionResponse =
      zio.aws.lexmodelsv2.model.DeleteBotVersionResponse(
        botId.map(value => value),
        botVersion.map(value => value),
        botStatus.map(value => value)
      )
    def botId: Option[Id]
    def botVersion: Option[NumericalBotVersion]
    def botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus]
    def getBotId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotVersion: ZIO[Any, AwsError, NumericalBotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getBotStatus: ZIO[Any, AwsError, zio.aws.lexmodelsv2.model.BotStatus] =
      AwsError.unwrapOptionField("botStatus", botStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse
  ) extends zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.ReadOnly {
    override val botId: Option[Id] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexmodelsv2.model.primitives.Id(value))
    override val botVersion: Option[NumericalBotVersion] = scala
      .Option(impl.botVersion())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.NumericalBotVersion(value)
      )
    override val botStatus: Option[zio.aws.lexmodelsv2.model.BotStatus] = scala
      .Option(impl.botStatus())
      .map(value => zio.aws.lexmodelsv2.model.BotStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotVersionResponse
  ): zio.aws.lexmodelsv2.model.DeleteBotVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
