package zio.aws.lexmodelsv2.model
import zio.aws.lexmodelsv2.model.primitives.{SkipResourceInUseCheck, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteBotRequest(
    botId: Id,
    skipResourceInUseCheck: Option[SkipResourceInUseCheck] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest = {
    import DeleteBotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest
      .builder()
      .botId(Id.unwrap(botId): java.lang.String)
      .optionallyWith(
        skipResourceInUseCheck.map(value =>
          SkipResourceInUseCheck.unwrap(value): java.lang.Boolean
        )
      )(_.skipResourceInUseCheck)
      .build()
  }
  def asReadOnly: zio.aws.lexmodelsv2.model.DeleteBotRequest.ReadOnly =
    zio.aws.lexmodelsv2.model.DeleteBotRequest.wrap(buildAwsValue())
}
object DeleteBotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexmodelsv2.model.DeleteBotRequest =
      zio.aws.lexmodelsv2.model
        .DeleteBotRequest(botId, skipResourceInUseCheck.map(value => value))
    def botId: Id
    def skipResourceInUseCheck: Option[SkipResourceInUseCheck]
    def getBotId: ZIO[Any, Nothing, Id] = ZIO.succeed(botId)
    def getSkipResourceInUseCheck: ZIO[Any, AwsError, SkipResourceInUseCheck] =
      AwsError.unwrapOptionField(
        "skipResourceInUseCheck",
        skipResourceInUseCheck
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest
  ) extends zio.aws.lexmodelsv2.model.DeleteBotRequest.ReadOnly {
    override val botId: Id =
      zio.aws.lexmodelsv2.model.primitives.Id(impl.botId())
    override val skipResourceInUseCheck: Option[SkipResourceInUseCheck] = scala
      .Option(impl.skipResourceInUseCheck())
      .map(value =>
        zio.aws.lexmodelsv2.model.primitives.SkipResourceInUseCheck(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexmodelsv2.model.DeleteBotRequest
  ): zio.aws.lexmodelsv2.model.DeleteBotRequest.ReadOnly = new Wrapper(impl)
}
