package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.FunctionName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteFunctionCodeSigningConfigRequest(
    functionName: FunctionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigRequest = {
    import DeleteFunctionCodeSigningConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigRequest
      .builder()
      .functionName(FunctionName.unwrap(functionName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.DeleteFunctionCodeSigningConfigRequest.ReadOnly =
    zio.aws.lambda.model.DeleteFunctionCodeSigningConfigRequest
      .wrap(buildAwsValue())
}
object DeleteFunctionCodeSigningConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lambda.model.DeleteFunctionCodeSigningConfigRequest =
      zio.aws.lambda.model.DeleteFunctionCodeSigningConfigRequest(functionName)
    def functionName: FunctionName
    def getFunctionName: ZIO[Any, Nothing, FunctionName] =
      ZIO.succeed(functionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigRequest
  ) extends zio.aws.lambda.model.DeleteFunctionCodeSigningConfigRequest.ReadOnly {
    override val functionName: FunctionName =
      zio.aws.lambda.model.primitives.FunctionName(impl.functionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.DeleteFunctionCodeSigningConfigRequest
  ): zio.aws.lambda.model.DeleteFunctionCodeSigningConfigRequest.ReadOnly =
    new Wrapper(impl)
}
