package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutFunctionRecursionConfigResponse(
    recursiveLoop: Optional[zio.aws.lambda.model.RecursiveLoop] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigResponse = {
    import PutFunctionRecursionConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigResponse
      .builder()
      .optionallyWith(recursiveLoop.map(value => value.unwrap))(_.recursiveLoop)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.PutFunctionRecursionConfigResponse.ReadOnly =
    zio.aws.lambda.model.PutFunctionRecursionConfigResponse
      .wrap(buildAwsValue())
}
object PutFunctionRecursionConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PutFunctionRecursionConfigResponse =
      zio.aws.lambda.model
        .PutFunctionRecursionConfigResponse(recursiveLoop.map(value => value))
    def recursiveLoop: Optional[zio.aws.lambda.model.RecursiveLoop]
    def getRecursiveLoop
        : ZIO[Any, AwsError, zio.aws.lambda.model.RecursiveLoop] =
      AwsError.unwrapOptionField("recursiveLoop", recursiveLoop)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigResponse
  ) extends zio.aws.lambda.model.PutFunctionRecursionConfigResponse.ReadOnly {
    override val recursiveLoop: Optional[zio.aws.lambda.model.RecursiveLoop] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recursiveLoop())
        .map(value => zio.aws.lambda.model.RecursiveLoop.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigResponse
  ): zio.aws.lambda.model.PutFunctionRecursionConfigResponse.ReadOnly =
    new Wrapper(impl)
}
