package zio.aws.lambda
import zio.aws.lambda.model.primitives.SubnetId.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.lambda.model.primitives.{
  SubnetId,
  SecurityGroupId,
  Method,
  Queue,
  TagValue,
  EnvironmentVariableName,
  Arn,
  LayerVersionArn,
  Weight,
  FunctionArn,
  Origin,
  Topic,
  Endpoint,
  EnvironmentVariableValue,
  AdditionalVersion,
  Header,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Action extends zio.prelude.Subtype[String]
    type Action = zio.aws.lambda.model.primitives.Action.Type
    object AdditionalVersion extends zio.prelude.Subtype[String]
    type AdditionalVersion =
      zio.aws.lambda.model.primitives.AdditionalVersion.Type
    object Alias extends zio.prelude.Subtype[String]
    type Alias = zio.aws.lambda.model.primitives.Alias.Type
    object AllowCredentials extends zio.prelude.Subtype[Boolean]
    type AllowCredentials =
      zio.aws.lambda.model.primitives.AllowCredentials.Type
    object Arn extends zio.prelude.Subtype[String]
    type Arn = zio.aws.lambda.model.primitives.Arn.Type
    object BatchSize extends zio.prelude.Subtype[Int]
    type BatchSize = zio.aws.lambda.model.primitives.BatchSize.Type
    object BisectBatchOnFunctionError extends zio.prelude.Subtype[Boolean]
    type BisectBatchOnFunctionError =
      zio.aws.lambda.model.primitives.BisectBatchOnFunctionError.Type
    object Blob extends zio.prelude.Subtype[Chunk[Byte]]
    type Blob = zio.aws.lambda.model.primitives.Blob.Type
    object CodeSigningConfigArn extends zio.prelude.Subtype[String]
    type CodeSigningConfigArn =
      zio.aws.lambda.model.primitives.CodeSigningConfigArn.Type
    object CodeSigningConfigId extends zio.prelude.Subtype[String]
    type CodeSigningConfigId =
      zio.aws.lambda.model.primitives.CodeSigningConfigId.Type
    object CollectionName extends zio.prelude.Subtype[String]
    type CollectionName = zio.aws.lambda.model.primitives.CollectionName.Type
    object DatabaseName extends zio.prelude.Subtype[String]
    type DatabaseName = zio.aws.lambda.model.primitives.DatabaseName.Type
    object Date extends zio.prelude.Subtype[Instant]
    type Date = zio.aws.lambda.model.primitives.Date.Type
    object Description extends zio.prelude.Subtype[String]
    type Description = zio.aws.lambda.model.primitives.Description.Type
    object DestinationArn extends zio.prelude.Subtype[String]
    type DestinationArn = zio.aws.lambda.model.primitives.DestinationArn.Type
    object Enabled extends zio.prelude.Subtype[Boolean]
    type Enabled = zio.aws.lambda.model.primitives.Enabled.Type
    object Endpoint extends zio.prelude.Subtype[String]
    type Endpoint = zio.aws.lambda.model.primitives.Endpoint.Type
    object EnvironmentVariableName extends zio.prelude.Subtype[String]
    type EnvironmentVariableName =
      zio.aws.lambda.model.primitives.EnvironmentVariableName.Type
    object EnvironmentVariableValue extends zio.prelude.Subtype[String]
    type EnvironmentVariableValue =
      zio.aws.lambda.model.primitives.EnvironmentVariableValue.Type
    object EphemeralStorageSize extends zio.prelude.Subtype[Int]
    type EphemeralStorageSize =
      zio.aws.lambda.model.primitives.EphemeralStorageSize.Type
    object EventSourceMappingArn extends zio.prelude.Subtype[String]
    type EventSourceMappingArn =
      zio.aws.lambda.model.primitives.EventSourceMappingArn.Type
    object EventSourceToken extends zio.prelude.Subtype[String]
    type EventSourceToken =
      zio.aws.lambda.model.primitives.EventSourceToken.Type
    object FileSystemArn extends zio.prelude.Subtype[String]
    type FileSystemArn = zio.aws.lambda.model.primitives.FileSystemArn.Type
    object FilterCriteriaErrorCode extends zio.prelude.Subtype[String]
    type FilterCriteriaErrorCode =
      zio.aws.lambda.model.primitives.FilterCriteriaErrorCode.Type
    object FilterCriteriaErrorMessage extends zio.prelude.Subtype[String]
    type FilterCriteriaErrorMessage =
      zio.aws.lambda.model.primitives.FilterCriteriaErrorMessage.Type
    object FunctionArn extends zio.prelude.Subtype[String]
    type FunctionArn = zio.aws.lambda.model.primitives.FunctionArn.Type
    object FunctionName extends zio.prelude.Subtype[String]
    type FunctionName = zio.aws.lambda.model.primitives.FunctionName.Type
    object FunctionUrl extends zio.prelude.Subtype[String]
    type FunctionUrl = zio.aws.lambda.model.primitives.FunctionUrl.Type
    object FunctionUrlQualifier extends zio.prelude.Subtype[String]
    type FunctionUrlQualifier =
      zio.aws.lambda.model.primitives.FunctionUrlQualifier.Type
    object Handler extends zio.prelude.Subtype[String]
    type Handler = zio.aws.lambda.model.primitives.Handler.Type
    object Header extends zio.prelude.Subtype[String]
    type Header = zio.aws.lambda.model.primitives.Header.Type
    type Integer = Int
    object KMSKeyArn extends zio.prelude.Subtype[String]
    type KMSKeyArn = zio.aws.lambda.model.primitives.KMSKeyArn.Type
    object LastUpdateStatusReason extends zio.prelude.Subtype[String]
    type LastUpdateStatusReason =
      zio.aws.lambda.model.primitives.LastUpdateStatusReason.Type
    object LayerArn extends zio.prelude.Subtype[String]
    type LayerArn = zio.aws.lambda.model.primitives.LayerArn.Type
    object LayerName extends zio.prelude.Subtype[String]
    type LayerName = zio.aws.lambda.model.primitives.LayerName.Type
    object LayerPermissionAllowedAction extends zio.prelude.Subtype[String]
    type LayerPermissionAllowedAction =
      zio.aws.lambda.model.primitives.LayerPermissionAllowedAction.Type
    object LayerPermissionAllowedPrincipal extends zio.prelude.Subtype[String]
    type LayerPermissionAllowedPrincipal =
      zio.aws.lambda.model.primitives.LayerPermissionAllowedPrincipal.Type
    object LayerVersionArn extends zio.prelude.Subtype[String]
    type LayerVersionArn = zio.aws.lambda.model.primitives.LayerVersionArn.Type
    object LayerVersionNumber extends zio.prelude.Subtype[Long]
    type LayerVersionNumber =
      zio.aws.lambda.model.primitives.LayerVersionNumber.Type
    object LicenseInfo extends zio.prelude.Subtype[String]
    type LicenseInfo = zio.aws.lambda.model.primitives.LicenseInfo.Type
    object LocalMountPath extends zio.prelude.Subtype[String]
    type LocalMountPath = zio.aws.lambda.model.primitives.LocalMountPath.Type
    object LogGroup extends zio.prelude.Subtype[String]
    type LogGroup = zio.aws.lambda.model.primitives.LogGroup.Type
    object MasterRegion extends zio.prelude.Subtype[String]
    type MasterRegion = zio.aws.lambda.model.primitives.MasterRegion.Type
    object MaxAge extends zio.prelude.Subtype[Int]
    type MaxAge = zio.aws.lambda.model.primitives.MaxAge.Type
    object MaxFunctionEventInvokeConfigListItems
        extends zio.prelude.Subtype[Int]
    type MaxFunctionEventInvokeConfigListItems =
      zio.aws.lambda.model.primitives.MaxFunctionEventInvokeConfigListItems.Type
    object MaxItems extends zio.prelude.Subtype[Int]
    type MaxItems = zio.aws.lambda.model.primitives.MaxItems.Type
    object MaxLayerListItems extends zio.prelude.Subtype[Int]
    type MaxLayerListItems =
      zio.aws.lambda.model.primitives.MaxLayerListItems.Type
    object MaxListItems extends zio.prelude.Subtype[Int]
    type MaxListItems = zio.aws.lambda.model.primitives.MaxListItems.Type
    object MaxProvisionedConcurrencyConfigListItems
        extends zio.prelude.Subtype[Int]
    type MaxProvisionedConcurrencyConfigListItems =
      zio.aws.lambda.model.primitives.MaxProvisionedConcurrencyConfigListItems.Type
    object MaximumBatchingWindowInSeconds extends zio.prelude.Subtype[Int]
    type MaximumBatchingWindowInSeconds =
      zio.aws.lambda.model.primitives.MaximumBatchingWindowInSeconds.Type
    object MaximumConcurrency extends zio.prelude.Subtype[Int]
    type MaximumConcurrency =
      zio.aws.lambda.model.primitives.MaximumConcurrency.Type
    object MaximumEventAgeInSeconds extends zio.prelude.Subtype[Int]
    type MaximumEventAgeInSeconds =
      zio.aws.lambda.model.primitives.MaximumEventAgeInSeconds.Type
    object MaximumRecordAgeInSeconds extends zio.prelude.Subtype[Int]
    type MaximumRecordAgeInSeconds =
      zio.aws.lambda.model.primitives.MaximumRecordAgeInSeconds.Type
    object MaximumRetryAttempts extends zio.prelude.Subtype[Int]
    type MaximumRetryAttempts =
      zio.aws.lambda.model.primitives.MaximumRetryAttempts.Type
    object MaximumRetryAttemptsEventSourceMapping
        extends zio.prelude.Subtype[Int]
    type MaximumRetryAttemptsEventSourceMapping =
      zio.aws.lambda.model.primitives.MaximumRetryAttemptsEventSourceMapping.Type
    object MemorySize extends zio.prelude.Subtype[Int]
    type MemorySize = zio.aws.lambda.model.primitives.MemorySize.Type
    object Method extends zio.prelude.Subtype[String]
    type Method = zio.aws.lambda.model.primitives.Method.Type
    object NameSpacedFunctionArn extends zio.prelude.Subtype[String]
    type NameSpacedFunctionArn =
      zio.aws.lambda.model.primitives.NameSpacedFunctionArn.Type
    object NamespacedFunctionName extends zio.prelude.Subtype[String]
    type NamespacedFunctionName =
      zio.aws.lambda.model.primitives.NamespacedFunctionName.Type
    object NamespacedStatementId extends zio.prelude.Subtype[String]
    type NamespacedStatementId =
      zio.aws.lambda.model.primitives.NamespacedStatementId.Type
    object NonNegativeInteger extends zio.prelude.Subtype[Int]
    type NonNegativeInteger =
      zio.aws.lambda.model.primitives.NonNegativeInteger.Type
    type NullableBoolean = Boolean
    object OrganizationId extends zio.prelude.Subtype[String]
    type OrganizationId = zio.aws.lambda.model.primitives.OrganizationId.Type
    object Origin extends zio.prelude.Subtype[String]
    type Origin = zio.aws.lambda.model.primitives.Origin.Type
    object ParallelizationFactor extends zio.prelude.Subtype[Int]
    type ParallelizationFactor =
      zio.aws.lambda.model.primitives.ParallelizationFactor.Type
    object Pattern extends zio.prelude.Subtype[String]
    type Pattern = zio.aws.lambda.model.primitives.Pattern.Type
    object PositiveInteger extends zio.prelude.Subtype[Int]
    type PositiveInteger = zio.aws.lambda.model.primitives.PositiveInteger.Type
    object Principal extends zio.prelude.Subtype[String]
    type Principal = zio.aws.lambda.model.primitives.Principal.Type
    object PrincipalOrgID extends zio.prelude.Subtype[String]
    type PrincipalOrgID = zio.aws.lambda.model.primitives.PrincipalOrgID.Type
    object Qualifier extends zio.prelude.Subtype[String]
    type Qualifier = zio.aws.lambda.model.primitives.Qualifier.Type
    object Queue extends zio.prelude.Subtype[String]
    type Queue = zio.aws.lambda.model.primitives.Queue.Type
    object ReservedConcurrentExecutions extends zio.prelude.Subtype[Int]
    type ReservedConcurrentExecutions =
      zio.aws.lambda.model.primitives.ReservedConcurrentExecutions.Type
    object ResourceArn extends zio.prelude.Subtype[String]
    type ResourceArn = zio.aws.lambda.model.primitives.ResourceArn.Type
    object RoleArn extends zio.prelude.Subtype[String]
    type RoleArn = zio.aws.lambda.model.primitives.RoleArn.Type
    object RuntimeVersionArn extends zio.prelude.Subtype[String]
    type RuntimeVersionArn =
      zio.aws.lambda.model.primitives.RuntimeVersionArn.Type
    object S3Bucket extends zio.prelude.Subtype[String]
    type S3Bucket = zio.aws.lambda.model.primitives.S3Bucket.Type
    object S3Key extends zio.prelude.Subtype[String]
    type S3Key = zio.aws.lambda.model.primitives.S3Key.Type
    object S3ObjectVersion extends zio.prelude.Subtype[String]
    type S3ObjectVersion = zio.aws.lambda.model.primitives.S3ObjectVersion.Type
    object SecurityGroupId extends zio.prelude.Subtype[String]
    type SecurityGroupId = zio.aws.lambda.model.primitives.SecurityGroupId.Type
    object SensitiveString extends zio.prelude.Subtype[String]
    type SensitiveString = zio.aws.lambda.model.primitives.SensitiveString.Type
    object SourceOwner extends zio.prelude.Subtype[String]
    type SourceOwner = zio.aws.lambda.model.primitives.SourceOwner.Type
    object StateReason extends zio.prelude.Subtype[String]
    type StateReason = zio.aws.lambda.model.primitives.StateReason.Type
    object StatementId extends zio.prelude.Subtype[String]
    type StatementId = zio.aws.lambda.model.primitives.StatementId.Type
    object SubnetId extends zio.prelude.Subtype[String]
    type SubnetId = zio.aws.lambda.model.primitives.SubnetId.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.lambda.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.lambda.model.primitives.TagValue.Type
    object TaggableResource extends zio.prelude.Subtype[String]
    type TaggableResource =
      zio.aws.lambda.model.primitives.TaggableResource.Type
    object Timeout extends zio.prelude.Subtype[Int]
    type Timeout = zio.aws.lambda.model.primitives.Timeout.Type
    object Timestamp extends zio.prelude.Subtype[String]
    type Timestamp = zio.aws.lambda.model.primitives.Timestamp.Type
    object Topic extends zio.prelude.Subtype[String]
    type Topic = zio.aws.lambda.model.primitives.Topic.Type
    object TumblingWindowInSeconds extends zio.prelude.Subtype[Int]
    type TumblingWindowInSeconds =
      zio.aws.lambda.model.primitives.TumblingWindowInSeconds.Type
    object URI extends zio.prelude.Subtype[String]
    type URI = zio.aws.lambda.model.primitives.URI.Type
    object UnqualifiedFunctionName extends zio.prelude.Subtype[String]
    type UnqualifiedFunctionName =
      zio.aws.lambda.model.primitives.UnqualifiedFunctionName.Type
    object UnreservedConcurrentExecutions extends zio.prelude.Subtype[Int]
    type UnreservedConcurrentExecutions =
      zio.aws.lambda.model.primitives.UnreservedConcurrentExecutions.Type
    object Version extends zio.prelude.Subtype[String]
    type Version = zio.aws.lambda.model.primitives.Version.Type
    object VpcId extends zio.prelude.Subtype[String]
    type VpcId = zio.aws.lambda.model.primitives.VpcId.Type
    object Weight extends zio.prelude.Subtype[Double]
    type Weight = zio.aws.lambda.model.primitives.Weight.Type
    object WorkingDirectory extends zio.prelude.Subtype[String]
    type WorkingDirectory =
      zio.aws.lambda.model.primitives.WorkingDirectory.Type
  }
  type AdditionalVersionWeights = Map[AdditionalVersion, Weight]
  type AliasList = List[zio.aws.lambda.model.AliasConfiguration]
  type AllowMethodsList = List[Method]
  type AllowOriginsList = List[Origin]
  type ArchitecturesList = List[zio.aws.lambda.model.Architecture]
  type CodeSigningConfigList = List[zio.aws.lambda.model.CodeSigningConfig]
  type CompatibleArchitectures = List[zio.aws.lambda.model.Architecture]
  type CompatibleRuntimes = List[zio.aws.lambda.model.Runtime]
  type EndpointLists = List[Endpoint]
  type Endpoints = Map[zio.aws.lambda.model.EndPointType, Iterable[Endpoint]]
  type EnvironmentVariables =
    Map[EnvironmentVariableName, EnvironmentVariableValue]
  type EventSourceMappingsList =
    List[zio.aws.lambda.model.EventSourceMappingConfiguration]
  type FileSystemConfigList = List[zio.aws.lambda.model.FileSystemConfig]
  type FilterList = List[zio.aws.lambda.model.Filter]
  type FunctionArnList = List[FunctionArn]
  type FunctionEventInvokeConfigList =
    List[zio.aws.lambda.model.FunctionEventInvokeConfig]
  type FunctionList = List[zio.aws.lambda.model.FunctionConfiguration]
  type FunctionResponseTypeList =
    List[zio.aws.lambda.model.FunctionResponseType]
  type FunctionUrlConfigList = List[zio.aws.lambda.model.FunctionUrlConfig]
  type HeadersList = List[Header]
  type LayerList = List[LayerVersionArn]
  type LayerVersionsList = List[zio.aws.lambda.model.LayerVersionsListItem]
  type LayersList = List[zio.aws.lambda.model.LayersListItem]
  type LayersReferenceList = List[zio.aws.lambda.model.Layer]
  type ProvisionedConcurrencyConfigList =
    List[zio.aws.lambda.model.ProvisionedConcurrencyConfigListItem]
  type Queues = List[Queue]
  type SecurityGroupIds = List[SecurityGroupId]
  type SigningProfileVersionArns = List[Arn]
  type SourceAccessConfigurations =
    List[zio.aws.lambda.model.SourceAccessConfiguration]
  type StringList = List[String]
  type SubnetIds = List[SubnetId]
  type TagKeyList = List[TagKey]
  type Tags = Map[TagKey, TagValue]
  type Topics = List[Topic]
}
