package zio.aws.lambda.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetFunctionRecursionConfigResponse(
    recursiveLoop: Optional[zio.aws.lambda.model.RecursiveLoop] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigResponse = {
    import GetFunctionRecursionConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigResponse
      .builder()
      .optionallyWith(recursiveLoop.map(value => value.unwrap))(_.recursiveLoop)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.GetFunctionRecursionConfigResponse.ReadOnly =
    zio.aws.lambda.model.GetFunctionRecursionConfigResponse
      .wrap(buildAwsValue())
}
object GetFunctionRecursionConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetFunctionRecursionConfigResponse =
      zio.aws.lambda.model
        .GetFunctionRecursionConfigResponse(recursiveLoop.map(value => value))
    def recursiveLoop: Optional[zio.aws.lambda.model.RecursiveLoop]
    def getRecursiveLoop
        : ZIO[Any, AwsError, zio.aws.lambda.model.RecursiveLoop] =
      AwsError.unwrapOptionField("recursiveLoop", recursiveLoop)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigResponse
  ) extends zio.aws.lambda.model.GetFunctionRecursionConfigResponse.ReadOnly {
    override val recursiveLoop: Optional[zio.aws.lambda.model.RecursiveLoop] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recursiveLoop())
        .map(value => zio.aws.lambda.model.RecursiveLoop.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigResponse
  ): zio.aws.lambda.model.GetFunctionRecursionConfigResponse.ReadOnly =
    new Wrapper(impl)
}
