package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{CollectionName, DatabaseName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DocumentDBEventSourceConfig(
    databaseName: Optional[DatabaseName] = Optional.Absent,
    collectionName: Optional[CollectionName] = Optional.Absent,
    fullDocument: Optional[zio.aws.lambda.model.FullDocument] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.DocumentDBEventSourceConfig = {
    import DocumentDBEventSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.DocumentDBEventSourceConfig
      .builder()
      .optionallyWith(
        databaseName.map(value => DatabaseName.unwrap(value): java.lang.String)
      )(_.databaseName)
      .optionallyWith(
        collectionName.map(value =>
          CollectionName.unwrap(value): java.lang.String
        )
      )(_.collectionName)
      .optionallyWith(fullDocument.map(value => value.unwrap))(_.fullDocument)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.DocumentDBEventSourceConfig.ReadOnly =
    zio.aws.lambda.model.DocumentDBEventSourceConfig.wrap(buildAwsValue())
}
object DocumentDBEventSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.DocumentDBEventSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.DocumentDBEventSourceConfig =
      zio.aws.lambda.model.DocumentDBEventSourceConfig(
        databaseName.map(value => value),
        collectionName.map(value => value),
        fullDocument.map(value => value)
      )
    def databaseName: Optional[DatabaseName]
    def collectionName: Optional[CollectionName]
    def fullDocument: Optional[zio.aws.lambda.model.FullDocument]
    def getDatabaseName: ZIO[Any, AwsError, DatabaseName] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getCollectionName: ZIO[Any, AwsError, CollectionName] =
      AwsError.unwrapOptionField("collectionName", collectionName)
    def getFullDocument: ZIO[Any, AwsError, zio.aws.lambda.model.FullDocument] =
      AwsError.unwrapOptionField("fullDocument", fullDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.DocumentDBEventSourceConfig
  ) extends zio.aws.lambda.model.DocumentDBEventSourceConfig.ReadOnly {
    override val databaseName: Optional[DatabaseName] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => zio.aws.lambda.model.primitives.DatabaseName(value))
    override val collectionName: Optional[CollectionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collectionName())
        .map(value => zio.aws.lambda.model.primitives.CollectionName(value))
    override val fullDocument: Optional[zio.aws.lambda.model.FullDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fullDocument())
        .map(value => zio.aws.lambda.model.FullDocument.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.DocumentDBEventSourceConfig
  ): zio.aws.lambda.model.DocumentDBEventSourceConfig.ReadOnly = new Wrapper(
    impl
  )
}
