package zio.aws.lambda.model
import scala.jdk.CollectionConverters.*
sealed trait SystemLogLevel {
  def unwrap: software.amazon.awssdk.services.lambda.model.SystemLogLevel
}
object SystemLogLevel {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.SystemLogLevel
  ): zio.aws.lambda.model.SystemLogLevel = value match {
    case software.amazon.awssdk.services.lambda.model.SystemLogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.SystemLogLevel.DEBUG =>
      val r = DEBUG
      r
    case software.amazon.awssdk.services.lambda.model.SystemLogLevel.INFO =>
      val r = INFO
      r
    case software.amazon.awssdk.services.lambda.model.SystemLogLevel.WARN =>
      val r = WARN
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.SystemLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SystemLogLevel =
      software.amazon.awssdk.services.lambda.model.SystemLogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object DEBUG extends zio.aws.lambda.model.SystemLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SystemLogLevel =
      software.amazon.awssdk.services.lambda.model.SystemLogLevel.DEBUG
  }
  case object INFO extends zio.aws.lambda.model.SystemLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SystemLogLevel =
      software.amazon.awssdk.services.lambda.model.SystemLogLevel.INFO
  }
  case object WARN extends zio.aws.lambda.model.SystemLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.SystemLogLevel =
      software.amazon.awssdk.services.lambda.model.SystemLogLevel.WARN
  }
}
