package zio.aws.lambda.model
import scala.jdk.CollectionConverters.*
sealed trait LogFormat {
  def unwrap: software.amazon.awssdk.services.lambda.model.LogFormat
}
object LogFormat {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.LogFormat
  ): zio.aws.lambda.model.LogFormat = value match {
    case software.amazon.awssdk.services.lambda.model.LogFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.LogFormat.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.lambda.model.LogFormat.TEXT =>
      val r = Text
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.LogFormat {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LogFormat =
      software.amazon.awssdk.services.lambda.model.LogFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object JSON extends zio.aws.lambda.model.LogFormat {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LogFormat =
      software.amazon.awssdk.services.lambda.model.LogFormat.JSON
  }
  case object Text extends zio.aws.lambda.model.LogFormat {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.LogFormat =
      software.amazon.awssdk.services.lambda.model.LogFormat.TEXT
  }
}
