package zio.aws.lambda.model
import scala.jdk.CollectionConverters.*
sealed trait ApplicationLogLevel {
  def unwrap: software.amazon.awssdk.services.lambda.model.ApplicationLogLevel
}
object ApplicationLogLevel {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.ApplicationLogLevel
  ): zio.aws.lambda.model.ApplicationLogLevel = value match {
    case software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.TRACE =>
      val r = TRACE
      r
    case software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.DEBUG =>
      val r = DEBUG
      r
    case software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.INFO =>
      val r = INFO
      r
    case software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.WARN =>
      val r = WARN
      r
    case software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.FATAL =>
      val r = FATAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lambda.model.ApplicationLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ApplicationLogLevel =
      software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object TRACE extends zio.aws.lambda.model.ApplicationLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ApplicationLogLevel =
      software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.TRACE
  }
  case object DEBUG extends zio.aws.lambda.model.ApplicationLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ApplicationLogLevel =
      software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.DEBUG
  }
  case object INFO extends zio.aws.lambda.model.ApplicationLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ApplicationLogLevel =
      software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.INFO
  }
  case object WARN extends zio.aws.lambda.model.ApplicationLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ApplicationLogLevel =
      software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.WARN
  }
  case object ERROR extends zio.aws.lambda.model.ApplicationLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ApplicationLogLevel =
      software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.ERROR
  }
  case object FATAL extends zio.aws.lambda.model.ApplicationLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.ApplicationLogLevel =
      software.amazon.awssdk.services.lambda.model.ApplicationLogLevel.FATAL
  }
}
