package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.UnqualifiedFunctionName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutFunctionRecursionConfigRequest(
    functionName: UnqualifiedFunctionName,
    recursiveLoop: zio.aws.lambda.model.RecursiveLoop
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigRequest = {
    import PutFunctionRecursionConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigRequest
      .builder()
      .functionName(
        UnqualifiedFunctionName.unwrap(functionName): java.lang.String
      )
      .recursiveLoop(recursiveLoop.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.PutFunctionRecursionConfigRequest.ReadOnly =
    zio.aws.lambda.model.PutFunctionRecursionConfigRequest.wrap(buildAwsValue())
}
object PutFunctionRecursionConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.PutFunctionRecursionConfigRequest =
      zio.aws.lambda.model
        .PutFunctionRecursionConfigRequest(functionName, recursiveLoop)
    def functionName: UnqualifiedFunctionName
    def recursiveLoop: zio.aws.lambda.model.RecursiveLoop
    def getFunctionName: ZIO[Any, Nothing, UnqualifiedFunctionName] =
      ZIO.succeed(functionName)
    def getRecursiveLoop
        : ZIO[Any, Nothing, zio.aws.lambda.model.RecursiveLoop] =
      ZIO.succeed(recursiveLoop)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigRequest
  ) extends zio.aws.lambda.model.PutFunctionRecursionConfigRequest.ReadOnly {
    override val functionName: UnqualifiedFunctionName =
      zio.aws.lambda.model.primitives
        .UnqualifiedFunctionName(impl.functionName())
    override val recursiveLoop: zio.aws.lambda.model.RecursiveLoop =
      zio.aws.lambda.model.RecursiveLoop.wrap(impl.recursiveLoop())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.PutFunctionRecursionConfigRequest
  ): zio.aws.lambda.model.PutFunctionRecursionConfigRequest.ReadOnly =
    new Wrapper(impl)
}
