package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  FilterCriteriaErrorMessage,
  FilterCriteriaErrorCode
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FilterCriteriaError(
    errorCode: Optional[FilterCriteriaErrorCode] = Optional.Absent,
    message: Optional[FilterCriteriaErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.FilterCriteriaError = {
    import FilterCriteriaError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.FilterCriteriaError
      .builder()
      .optionallyWith(
        errorCode.map(value =>
          FilterCriteriaErrorCode.unwrap(value): java.lang.String
        )
      )(_.errorCode)
      .optionallyWith(
        message.map(value =>
          FilterCriteriaErrorMessage.unwrap(value): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.FilterCriteriaError.ReadOnly =
    zio.aws.lambda.model.FilterCriteriaError.wrap(buildAwsValue())
}
object FilterCriteriaError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.FilterCriteriaError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.FilterCriteriaError =
      zio.aws.lambda.model.FilterCriteriaError(
        errorCode.map(value => value),
        message.map(value => value)
      )
    def errorCode: Optional[FilterCriteriaErrorCode]
    def message: Optional[FilterCriteriaErrorMessage]
    def getErrorCode: ZIO[Any, AwsError, FilterCriteriaErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, FilterCriteriaErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.FilterCriteriaError
  ) extends zio.aws.lambda.model.FilterCriteriaError.ReadOnly {
    override val errorCode: Optional[FilterCriteriaErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value =>
          zio.aws.lambda.model.primitives.FilterCriteriaErrorCode(value)
        )
    override val message: Optional[FilterCriteriaErrorMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.lambda.model.primitives.FilterCriteriaErrorMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.FilterCriteriaError
  ): zio.aws.lambda.model.FilterCriteriaError.ReadOnly = new Wrapper(impl)
}
