package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{TagValue, TagKey, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCodeSigningConfigRequest(
    description: Optional[Description] = Optional.Absent,
    allowedPublishers: zio.aws.lambda.model.AllowedPublishers,
    codeSigningPolicies: Optional[zio.aws.lambda.model.CodeSigningPolicies] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest = {
    import CreateCodeSigningConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .allowedPublishers(allowedPublishers.buildAwsValue())
      .optionallyWith(codeSigningPolicies.map(value => value.buildAwsValue()))(
        _.codeSigningPolicies
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.CreateCodeSigningConfigRequest.ReadOnly =
    zio.aws.lambda.model.CreateCodeSigningConfigRequest.wrap(buildAwsValue())
}
object CreateCodeSigningConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.CreateCodeSigningConfigRequest =
      zio.aws.lambda.model.CreateCodeSigningConfigRequest(
        description.map(value => value),
        allowedPublishers.asEditable,
        codeSigningPolicies.map(value => value.asEditable),
        tags.map(value => value)
      )
    def description: Optional[Description]
    def allowedPublishers: zio.aws.lambda.model.AllowedPublishers.ReadOnly
    def codeSigningPolicies
        : Optional[zio.aws.lambda.model.CodeSigningPolicies.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getAllowedPublishers
        : ZIO[Any, Nothing, zio.aws.lambda.model.AllowedPublishers.ReadOnly] =
      ZIO.succeed(allowedPublishers)
    def getCodeSigningPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.lambda.model.CodeSigningPolicies.ReadOnly
    ] = AwsError.unwrapOptionField("codeSigningPolicies", codeSigningPolicies)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest
  ) extends zio.aws.lambda.model.CreateCodeSigningConfigRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.lambda.model.primitives.Description(value))
    override val allowedPublishers
        : zio.aws.lambda.model.AllowedPublishers.ReadOnly =
      zio.aws.lambda.model.AllowedPublishers.wrap(impl.allowedPublishers())
    override val codeSigningPolicies
        : Optional[zio.aws.lambda.model.CodeSigningPolicies.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeSigningPolicies())
        .map(value => zio.aws.lambda.model.CodeSigningPolicies.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lambda.model.primitives
              .TagKey(key) -> zio.aws.lambda.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.CreateCodeSigningConfigRequest
  ): zio.aws.lambda.model.CreateCodeSigningConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
