package zio.aws.lambda.model
import scala.jdk.CollectionConverters.*
sealed trait RecursiveLoop {
  def unwrap: software.amazon.awssdk.services.lambda.model.RecursiveLoop
}
object RecursiveLoop {
  def wrap(
      value: software.amazon.awssdk.services.lambda.model.RecursiveLoop
  ): zio.aws.lambda.model.RecursiveLoop = value match {
    case software.amazon.awssdk.services.lambda.model.RecursiveLoop.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lambda.model.RecursiveLoop.ALLOW =>
      val r = Allow
      r
    case software.amazon.awssdk.services.lambda.model.RecursiveLoop.TERMINATE =>
      val r = Terminate
      r
  }
  case object unknownToSdkVersion extends zio.aws.lambda.model.RecursiveLoop {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.RecursiveLoop =
      software.amazon.awssdk.services.lambda.model.RecursiveLoop.UNKNOWN_TO_SDK_VERSION
  }
  case object Allow extends zio.aws.lambda.model.RecursiveLoop {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.RecursiveLoop =
      software.amazon.awssdk.services.lambda.model.RecursiveLoop.ALLOW
  }
  case object Terminate extends zio.aws.lambda.model.RecursiveLoop {
    override def unwrap
        : software.amazon.awssdk.services.lambda.model.RecursiveLoop =
      software.amazon.awssdk.services.lambda.model.RecursiveLoop.TERMINATE
  }
}
