package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.UnqualifiedFunctionName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetFunctionRecursionConfigRequest(
    functionName: UnqualifiedFunctionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigRequest = {
    import GetFunctionRecursionConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigRequest
      .builder()
      .functionName(
        UnqualifiedFunctionName.unwrap(functionName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lambda.model.GetFunctionRecursionConfigRequest.ReadOnly =
    zio.aws.lambda.model.GetFunctionRecursionConfigRequest.wrap(buildAwsValue())
}
object GetFunctionRecursionConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.GetFunctionRecursionConfigRequest =
      zio.aws.lambda.model.GetFunctionRecursionConfigRequest(functionName)
    def functionName: UnqualifiedFunctionName
    def getFunctionName: ZIO[Any, Nothing, UnqualifiedFunctionName] =
      ZIO.succeed(functionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigRequest
  ) extends zio.aws.lambda.model.GetFunctionRecursionConfigRequest.ReadOnly {
    override val functionName: UnqualifiedFunctionName =
      zio.aws.lambda.model.primitives
        .UnqualifiedFunctionName(impl.functionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.GetFunctionRecursionConfigRequest
  ): zio.aws.lambda.model.GetFunctionRecursionConfigRequest.ReadOnly =
    new Wrapper(impl)
}
