package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  NullableBoolean,
  SecurityGroupId,
  SubnetId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcConfig(
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    ipv6AllowedForDualStack: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.VpcConfig = {
    import VpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.VpcConfig
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        ipv6AllowedForDualStack.map(value => value: java.lang.Boolean)
      )(_.ipv6AllowedForDualStack)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.VpcConfig.ReadOnly =
    zio.aws.lambda.model.VpcConfig.wrap(buildAwsValue())
}
object VpcConfig {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lambda.model.VpcConfig] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.VpcConfig =
      zio.aws.lambda.model.VpcConfig(
        subnetIds.map(value => value),
        securityGroupIds.map(value => value),
        ipv6AllowedForDualStack.map(value => value)
      )
    def subnetIds: Optional[List[SubnetId]]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def ipv6AllowedForDualStack: Optional[NullableBoolean]
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getIpv6AllowedForDualStack: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "ipv6AllowedForDualStack",
        ipv6AllowedForDualStack
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.VpcConfig
  ) extends zio.aws.lambda.model.VpcConfig.ReadOnly {
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.SubnetId(item)
        }.toList
      )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val ipv6AllowedForDualStack: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6AllowedForDualStack())
        .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.VpcConfig
  ): zio.aws.lambda.model.VpcConfig.ReadOnly = new Wrapper(impl)
}
