package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.LogGroup
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LoggingConfig(
    logFormat: Optional[zio.aws.lambda.model.LogFormat] = Optional.Absent,
    applicationLogLevel: Optional[zio.aws.lambda.model.ApplicationLogLevel] =
      Optional.Absent,
    systemLogLevel: Optional[zio.aws.lambda.model.SystemLogLevel] =
      Optional.Absent,
    logGroup: Optional[LogGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.LoggingConfig = {
    import LoggingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.LoggingConfig
      .builder()
      .optionallyWith(logFormat.map(value => value.unwrap))(_.logFormat)
      .optionallyWith(applicationLogLevel.map(value => value.unwrap))(
        _.applicationLogLevel
      )
      .optionallyWith(systemLogLevel.map(value => value.unwrap))(
        _.systemLogLevel
      )
      .optionallyWith(
        logGroup.map(value => LogGroup.unwrap(value): java.lang.String)
      )(_.logGroup)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.LoggingConfig.ReadOnly =
    zio.aws.lambda.model.LoggingConfig.wrap(buildAwsValue())
}
object LoggingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.LoggingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.LoggingConfig =
      zio.aws.lambda.model.LoggingConfig(
        logFormat.map(value => value),
        applicationLogLevel.map(value => value),
        systemLogLevel.map(value => value),
        logGroup.map(value => value)
      )
    def logFormat: Optional[zio.aws.lambda.model.LogFormat]
    def applicationLogLevel: Optional[zio.aws.lambda.model.ApplicationLogLevel]
    def systemLogLevel: Optional[zio.aws.lambda.model.SystemLogLevel]
    def logGroup: Optional[LogGroup]
    def getLogFormat: ZIO[Any, AwsError, zio.aws.lambda.model.LogFormat] =
      AwsError.unwrapOptionField("logFormat", logFormat)
    def getApplicationLogLevel
        : ZIO[Any, AwsError, zio.aws.lambda.model.ApplicationLogLevel] =
      AwsError.unwrapOptionField("applicationLogLevel", applicationLogLevel)
    def getSystemLogLevel
        : ZIO[Any, AwsError, zio.aws.lambda.model.SystemLogLevel] =
      AwsError.unwrapOptionField("systemLogLevel", systemLogLevel)
    def getLogGroup: ZIO[Any, AwsError, LogGroup] =
      AwsError.unwrapOptionField("logGroup", logGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.LoggingConfig
  ) extends zio.aws.lambda.model.LoggingConfig.ReadOnly {
    override val logFormat: Optional[zio.aws.lambda.model.LogFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logFormat())
        .map(value => zio.aws.lambda.model.LogFormat.wrap(value))
    override val applicationLogLevel
        : Optional[zio.aws.lambda.model.ApplicationLogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationLogLevel())
        .map(value => zio.aws.lambda.model.ApplicationLogLevel.wrap(value))
    override val systemLogLevel: Optional[zio.aws.lambda.model.SystemLogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.systemLogLevel())
        .map(value => zio.aws.lambda.model.SystemLogLevel.wrap(value))
    override val logGroup: Optional[LogGroup] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroup())
      .map(value => zio.aws.lambda.model.primitives.LogGroup(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.LoggingConfig
  ): zio.aws.lambda.model.LoggingConfig.ReadOnly = new Wrapper(impl)
}
