package zio.aws.lambda.model
import zio.aws.lambda.model.primitives.{
  NullableBoolean,
  VpcId,
  SecurityGroupId,
  SubnetId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VpcConfigResponse(
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    ipv6AllowedForDualStack: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.VpcConfigResponse = {
    import VpcConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.VpcConfigResponse
      .builder()
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        ipv6AllowedForDualStack.map(value => value: java.lang.Boolean)
      )(_.ipv6AllowedForDualStack)
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.VpcConfigResponse.ReadOnly =
    zio.aws.lambda.model.VpcConfigResponse.wrap(buildAwsValue())
}
object VpcConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.VpcConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.VpcConfigResponse =
      zio.aws.lambda.model.VpcConfigResponse(
        subnetIds.map(value => value),
        securityGroupIds.map(value => value),
        vpcId.map(value => value),
        ipv6AllowedForDualStack.map(value => value)
      )
    def subnetIds: Optional[List[SubnetId]]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def vpcId: Optional[VpcId]
    def ipv6AllowedForDualStack: Optional[NullableBoolean]
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getIpv6AllowedForDualStack: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "ipv6AllowedForDualStack",
        ipv6AllowedForDualStack
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.VpcConfigResponse
  ) extends zio.aws.lambda.model.VpcConfigResponse.ReadOnly {
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lambda.model.primitives.SubnetId(item)
        }.toList
      )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lambda.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.lambda.model.primitives.VpcId(value))
    override val ipv6AllowedForDualStack: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6AllowedForDualStack())
        .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.VpcConfigResponse
  ): zio.aws.lambda.model.VpcConfigResponse.ReadOnly = new Wrapper(impl)
}
