package zio.aws.lambda.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.lambda.model.primitives.MaxLayerListItems
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListLayersRequest(
    compatibleRuntime: Optional[zio.aws.lambda.model.Runtime] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[MaxLayerListItems] = Optional.Absent,
    compatibleArchitecture: Optional[zio.aws.lambda.model.Architecture] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lambda.model.ListLayersRequest = {
    import ListLayersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lambda.model.ListLayersRequest
      .builder()
      .optionallyWith(compatibleRuntime.map(value => value.unwrap))(
        _.compatibleRuntime
      )
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        maxItems.map(value => MaxLayerListItems.unwrap(value): Integer)
      )(_.maxItems)
      .optionallyWith(compatibleArchitecture.map(value => value.unwrap))(
        _.compatibleArchitecture
      )
      .build()
  }
  def asReadOnly: zio.aws.lambda.model.ListLayersRequest.ReadOnly =
    zio.aws.lambda.model.ListLayersRequest.wrap(buildAwsValue())
}
object ListLayersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lambda.model.ListLayersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lambda.model.ListLayersRequest =
      zio.aws.lambda.model.ListLayersRequest(
        compatibleRuntime.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value),
        compatibleArchitecture.map(value => value)
      )
    def compatibleRuntime: Optional[zio.aws.lambda.model.Runtime]
    def marker: Optional[String]
    def maxItems: Optional[MaxLayerListItems]
    def compatibleArchitecture: Optional[zio.aws.lambda.model.Architecture]
    def getCompatibleRuntime: ZIO[Any, AwsError, zio.aws.lambda.model.Runtime] =
      AwsError.unwrapOptionField("compatibleRuntime", compatibleRuntime)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, MaxLayerListItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getCompatibleArchitecture
        : ZIO[Any, AwsError, zio.aws.lambda.model.Architecture] = AwsError
      .unwrapOptionField("compatibleArchitecture", compatibleArchitecture)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lambda.model.ListLayersRequest
  ) extends zio.aws.lambda.model.ListLayersRequest.ReadOnly {
    override val compatibleRuntime: Optional[zio.aws.lambda.model.Runtime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compatibleRuntime())
        .map(value => zio.aws.lambda.model.Runtime.wrap(value))
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[MaxLayerListItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.lambda.model.primitives.MaxLayerListItems(value))
    override val compatibleArchitecture
        : Optional[zio.aws.lambda.model.Architecture] = zio.aws.core.internal
      .optionalFromNullable(impl.compatibleArchitecture())
      .map(value => zio.aws.lambda.model.Architecture.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lambda.model.ListLayersRequest
  ): zio.aws.lambda.model.ListLayersRequest.ReadOnly = new Wrapper(impl)
}
